/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.List;
import org.apache.commons.resources.Messages;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.service.archetype.ValidationError;

public class ValidationException
extends OpenVPMSException {
    private final ErrorCode errorCode;
    private final List<ValidationError> errors;
    private static final Messages messages = Messages.getMessages((String)"org.openvpms.component.business.service.archetype.errmessages");
    private static final long serialVersionUID = 1L;

    public ValidationException(List<ValidationError> errors, ErrorCode errorCode) {
        super(org.openvpms.component.i18n.Messages.create((String)messages.getMessage(errorCode.toString())));
        this.errors = errors;
        this.errorCode = errorCode;
    }

    public ValidationException(List<ValidationError> errors, ErrorCode errorCode, Object[] params) {
        super(org.openvpms.component.i18n.Messages.create((String)messages.getMessage(errorCode.toString(), params)));
        this.errors = errors;
        this.errorCode = errorCode;
    }

    public ValidationException(List<ValidationError> errors, ErrorCode errorCode, Throwable cause) {
        super(org.openvpms.component.i18n.Messages.create((String)messages.getMessage(errorCode.toString())), cause);
        this.errors = errors;
        this.errorCode = errorCode;
    }

    public ValidationException(List<ValidationError> errors, ErrorCode errorCode, Object[] params, Throwable cause) {
        super(org.openvpms.component.i18n.Messages.create((String)messages.getMessage(errorCode.toString(), params)), cause);
        this.errors = errors;
        this.errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getMessage());
        buf.append(" ").append((Object)this.getErrorCode()).append("\n");
        for (ValidationError error : this.errors) {
            buf.append("\tnode:").append(error.getNode()).append(" msg:").append(error.getMessage()).append("\n");
        }
        return buf.toString();
    }

    public static enum ErrorCode {
        FailedToValidObjectAgainstArchetype;

    }
}

