/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.business.service.archetype.helper.IMObjectGraph;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;

public class MapIMObjectGraph
implements IMObjectGraph {
    private final IMObject primary;
    private final Map<Reference, IMObject> objects = new HashMap<Reference, IMObject>();

    public MapIMObjectGraph(IMObject primary, List<IMObject> related) {
        this.primary = primary;
        this.objects.put(primary.getObjectReference(), primary);
        related.forEach(object -> this.objects.putIfAbsent(object.getObjectReference(), (IMObject)object));
    }

    @Override
    public IMObject getPrimary() {
        return this.primary;
    }

    @Override
    public <T> T getPrimary(Class<T> type) {
        return type.cast(this.primary);
    }

    @Override
    public IMObject get(Reference reference) {
        return this.objects.get(reference);
    }

    @Override
    public <T extends IMObject> T get(Reference reference, Class<T> type) {
        return (T)((IMObject)type.cast(this.get(reference)));
    }

    @Override
    public Set<IMObject> getObjects() {
        return new HashSet<IMObject>(this.objects.values());
    }
}

