/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.math.BigDecimal;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.system.common.util.ClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JXPathGenericObjectCreationFactory
extends AbstractFactory {
    private static final Logger logger = LoggerFactory.getLogger(JXPathGenericObjectCreationFactory.class);

    public boolean createObject(JXPathContext context, Pointer ptr, Object parent, String name, int index) {
        try {
            Class<?> clazz;
            NodeDescriptor node = (NodeDescriptor)context.getVariables().getVariable("node");
            if (logger.isDebugEnabled()) {
                logger.debug("root={}, parent={}, name={}, index={}, type={}", new Object[]{context.getContextBean(), parent, name, index, node.getType()});
            }
            if ((clazz = ClassHelper.getClass(node.getType())) == Boolean.class) {
                ptr.setValue((Object)Boolean.FALSE);
            } else if (clazz == Integer.class) {
                ptr.setValue((Object)0);
            } else if (clazz == Long.class) {
                ptr.setValue((Object)0L);
            } else if (clazz == Double.class) {
                ptr.setValue((Object)0.0);
            } else if (clazz == Float.class) {
                ptr.setValue((Object)Float.valueOf(0.0f));
            } else if (clazz == Short.class) {
                ptr.setValue((Object)0);
            } else if (clazz == Byte.class) {
                ptr.setValue((Object)0);
            } else if (clazz == Money.class) {
                ptr.setValue((Object)Money.ZERO);
            } else if (clazz == BigDecimal.class) {
                ptr.setValue((Object)BigDecimal.ZERO);
            } else {
                ptr.setValue(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception exception) {
            logger.error("root={}, parent={}, name={}, index={}", new Object[]{context.getContextBean(), parent, name, index, exception});
            return false;
        }
        return true;
    }
}

