/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.archetype.AssertionTypeDescriptor;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.service.archetype.ValidationError;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NodeSet;
import org.openvpms.component.system.common.query.ObjectSet;

public abstract class DelegatingArchetypeService
implements IArchetypeService {
    private final IArchetypeService service;

    protected DelegatingArchetypeService(IArchetypeService service) {
        this.service = service;
    }

    public List<String> getArchetypes(String archetype, boolean primaryOnly) {
        return this.service.getArchetypes(archetype, primaryOnly);
    }

    @Override
    public ArchetypeDescriptor getArchetypeDescriptor(String shortName) {
        return this.service.getArchetypeDescriptor(shortName);
    }

    @Override
    public IMObject create(String shortName) {
        return this.service.create(shortName);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T create(String archetype, Class<T> type) {
        return (T)this.service.create(archetype, type);
    }

    @Override
    public IMObject create(ArchetypeId id) {
        return this.service.create(id);
    }

    public List<ValidationError> validate(org.openvpms.component.model.object.IMObject object) {
        return this.service.validate(object);
    }

    @Override
    public void validateObject(org.openvpms.component.model.object.IMObject object) {
        this.service.validateObject(object);
    }

    public void deriveValues(org.openvpms.component.model.object.IMObject object) {
        this.service.deriveValues(object);
    }

    public void deriveValue(org.openvpms.component.model.object.IMObject object, String node) {
        this.service.deriveValue(object, node);
    }

    public List<org.openvpms.component.model.archetype.ArchetypeDescriptor> getArchetypeDescriptors() {
        return this.service.getArchetypeDescriptors();
    }

    public List<org.openvpms.component.model.archetype.ArchetypeDescriptor> getArchetypeDescriptors(String shortName) {
        return this.service.getArchetypeDescriptors(shortName);
    }

    public AssertionTypeDescriptor getAssertionTypeDescriptor(String name) {
        return this.service.getAssertionTypeDescriptor(name);
    }

    public List<AssertionTypeDescriptor> getAssertionTypeDescriptors() {
        return this.service.getAssertionTypeDescriptors();
    }

    @Override
    public void save(org.openvpms.component.model.object.IMObject object) {
        this.save(object, true);
    }

    @Override
    public void save(Collection<? extends org.openvpms.component.model.object.IMObject> objects) {
        this.save(objects, true);
    }

    @Override
    @Deprecated
    public void save(org.openvpms.component.model.object.IMObject object, boolean validate) {
        this.service.save(object, validate);
    }

    @Override
    @Deprecated
    public void save(Collection<? extends org.openvpms.component.model.object.IMObject> objects, boolean validate) {
        this.service.save(objects, validate);
    }

    @Override
    public void remove(org.openvpms.component.model.object.IMObject object) {
        this.service.remove(object);
    }

    @Override
    public void remove(Reference reference) {
        this.service.remove(reference);
    }

    @Override
    public IMObject get(Reference reference) {
        return this.service.get(reference);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T get(Reference reference, Class<T> type) {
        return (T)this.service.get(reference, type);
    }

    public org.openvpms.component.model.object.IMObject get(String archetype, long id) {
        return this.service.get(archetype, id);
    }

    public org.openvpms.component.model.object.IMObject get(String archetype, long id, boolean active) {
        return this.service.get(archetype, id, active);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T get(String archetype, long id, Class<T> type) {
        return (T)this.service.get(archetype, id, type);
    }

    @Override
    public IMObject get(Reference reference, boolean active) {
        return this.service.get(reference, active);
    }

    @Override
    public IPage<IMObject> get(IArchetypeQuery query) {
        return this.service.get(query);
    }

    @Override
    public IPage<IMObject> get(IArchetypeQuery query, Collection<String> nodes) {
        return this.service.get(query, nodes);
    }

    @Override
    public IPage<ObjectSet> getObjects(IArchetypeQuery query) {
        return this.service.getObjects(query);
    }

    @Override
    public IPage<NodeSet> getNodes(IArchetypeQuery query, Collection<String> nodes) {
        return this.service.getNodes(query, nodes);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.service.getCriteriaBuilder();
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> query) {
        return this.service.createQuery(query);
    }

    @Override
    public List<String> getArchetypeShortNames() {
        return this.service.getArchetypeShortNames();
    }

    @Override
    public List<String> getArchetypeShortNames(String shortName, boolean primaryOnly) {
        return this.service.getArchetypeShortNames(shortName, primaryOnly);
    }

    @Override
    public List<Object> executeRule(String ruleUri, Map<String, Object> props, List<Object> facts) {
        return this.service.executeRule(ruleUri, props, facts);
    }

    @Override
    public void addListener(String shortName, IArchetypeServiceListener listener) {
        this.service.addListener(shortName, listener);
    }

    @Override
    public void removeListener(String shortName, IArchetypeServiceListener listener) {
        this.service.removeListener(shortName, listener);
    }

    public org.openvpms.component.model.bean.IMObjectBean getBean(org.openvpms.component.model.object.IMObject object) {
        return new IMObjectBean(object, this);
    }

    protected IArchetypeService getService() {
        return this.service;
    }
}

