/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.security;

import java.util.StringTokenizer;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.security.GrantedAuthorityException;
import org.springframework.security.core.GrantedAuthority;

public class ArchetypeAwareGrantedAuthority
extends IMObject
implements GrantedAuthority {
    private static final long serialVersionUID = 1L;
    private String prefix = "archetype";
    private String authority;
    private String serviceName;
    private String method;
    private String shortName;

    public ArchetypeAwareGrantedAuthority() {
    }

    public ArchetypeAwareGrantedAuthority(String str) {
        StringTokenizer tokens = new StringTokenizer(str, ":");
        if (tokens.countTokens() != 3) {
            throw new GrantedAuthorityException(GrantedAuthorityException.ErrorCode.InvalidGrantAuthorityFormat, new Object[]{str});
        }
        if (!tokens.nextToken().equals(this.prefix)) {
            throw new GrantedAuthorityException(GrantedAuthorityException.ErrorCode.InvalidPrefix);
        }
        StringTokenizer temp = new StringTokenizer(tokens.nextToken(), ".");
        if (temp.countTokens() != 2) {
            throw new GrantedAuthorityException(GrantedAuthorityException.ErrorCode.InvalidServiceMethodFormat, new Object[]{temp});
        }
        this.serviceName = temp.nextToken();
        this.method = temp.nextToken();
        this.shortName = tokens.nextToken();
        this.authority = str;
    }

    public String getAuthority() {
        if (this.authority == null) {
            this.authority = this.prefix + ":" + this.serviceName + "." + this.method + ":" + this.shortName;
        }
        return this.authority;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    void setAuthority(String authority) {
        this.authority = authority;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArchetypeAwareGrantedAuthority copy = (ArchetypeAwareGrantedAuthority)super.clone();
        copy.shortName = this.shortName;
        copy.authority = this.authority;
        copy.method = this.method;
        copy.prefix = this.prefix;
        copy.serviceName = this.serviceName;
        return copy;
    }
}

