/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.lookup;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.text.WordUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.common.AuditableIMObject;
import org.openvpms.component.business.domain.im.lookup.LookupRelationshipException;
import org.openvpms.component.model.lookup.LookupLink;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.Reference;

public class Lookup
extends AuditableIMObject
implements org.openvpms.component.model.lookup.Lookup {
    private String code;
    private boolean defaultLookup;
    private Set<LookupRelationship> sourceLookupRelationships = new HashSet<LookupRelationship>();
    private Set<LookupRelationship> targetLookupRelationships = new HashSet<LookupRelationship>();
    private Set<LookupLink> lookupLinks = new HashSet<LookupLink>();
    private static final long serialVersionUID = 3L;

    public Lookup() {
    }

    public Lookup(ArchetypeId archetypeId, String code) {
        this(archetypeId, code, null);
    }

    public Lookup(ArchetypeId archetypeId, String code, String name) {
        this.setArchetypeId(archetypeId);
        this.setName(name);
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null && this.code != null) {
            name = this.code.replace('_', ' ');
            name = WordUtils.capitalizeFully((String)name);
        }
        return name;
    }

    public boolean isDefaultLookup() {
        return this.defaultLookup;
    }

    public void setDefaultLookup(boolean defaultLookup) {
        this.defaultLookup = defaultLookup;
    }

    public Set<LookupRelationship> getSourceLookupRelationships() {
        return this.sourceLookupRelationships;
    }

    public void setSourceLookupRelationships(Set<LookupRelationship> relationships) {
        this.sourceLookupRelationships = relationships;
    }

    public void addSourceLookupRelationship(LookupRelationship relationship) {
        this.sourceLookupRelationships.add(relationship);
    }

    public void removeSourceLookupRelationship(LookupRelationship relationship) {
        this.sourceLookupRelationships.remove(relationship);
    }

    public Set<LookupRelationship> getTargetLookupRelationships() {
        return this.targetLookupRelationships;
    }

    public void setTargetLookupRelationships(Set<LookupRelationship> relationships) {
        this.targetLookupRelationships = relationships;
    }

    public void addTargetLookupRelationship(LookupRelationship relationship) {
        this.targetLookupRelationships.add(relationship);
    }

    public void removeTargetLookupRelationship(LookupRelationship relationship) {
        this.targetLookupRelationships.remove(relationship);
    }

    public void addLookupRelationship(LookupRelationship relationship) {
        if (relationship.getSource().getLinkId().equals(this.getLinkId()) && relationship.getSource().getArchetype().equals(this.getArchetype())) {
            this.addSourceLookupRelationship(relationship);
        } else if (relationship.getTarget().getLinkId().equals(this.getLinkId()) && relationship.getTarget().getArchetype().equals(this.getArchetype())) {
            this.addTargetLookupRelationship(relationship);
        } else {
            throw new LookupRelationshipException(LookupRelationshipException.ErrorCode.FailedToAddLookRelationship, new Object[]{relationship.getSource(), relationship.getTarget()});
        }
    }

    public void removeLookupRelationship(LookupRelationship relationship) {
        if (relationship.getSource().getLinkId().equals(this.getLinkId()) && relationship.getSource().getArchetype().equals(this.getArchetype())) {
            this.removeSourceLookupRelationship(relationship);
        } else if (relationship.getTarget().getLinkId().equals(this.getLinkId()) && relationship.getTarget().getArchetype().equals(this.getArchetype())) {
            this.removeTargetLookupRelationship(relationship);
        } else {
            throw new LookupRelationshipException(LookupRelationshipException.ErrorCode.FailedToRemoveLookRelationship, new Object[]{relationship.getSource(), relationship.getTarget()});
        }
    }

    public Set<LookupRelationship> getLookupRelationships() {
        HashSet<LookupRelationship> relationships = new HashSet<LookupRelationship>(this.sourceLookupRelationships);
        relationships.addAll(this.targetLookupRelationships);
        return relationships;
    }

    public void addLookupLink(LookupLink link) {
        link.setSource((Reference)this.getObjectReference());
        this.lookupLinks.add(link);
    }

    public void removeLookupLink(LookupLink link) {
        this.lookupLinks.remove(link);
    }

    public Set<LookupLink> getLookupLinks() {
        return this.lookupLinks;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof org.openvpms.component.model.lookup.Lookup)) {
            return false;
        }
        org.openvpms.component.model.lookup.Lookup rhs = (org.openvpms.component.model.lookup.Lookup)obj;
        return Objects.equals(this.code, rhs.getCode()) && Objects.equals(this.getArchetype(), rhs.getArchetype());
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getArchetypeId()).append((Object)this.code).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("code", (Object)this.getCode()).append("default", this.isDefaultLookup()).toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Lookup copy = (Lookup)super.clone();
        copy.sourceLookupRelationships = new HashSet<LookupRelationship>(this.sourceLookupRelationships);
        copy.targetLookupRelationships = new HashSet<LookupRelationship>(this.targetLookupRelationships);
        copy.lookupLinks = new HashSet<LookupLink>(this.lookupLinks);
        return copy;
    }
}

