/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.datatypes.basic;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.openvpms.component.business.domain.im.datatypes.basic.TypedValue;

public class TypedValueMap
implements Map<String, Object> {
    private final Map<String, TypedValue> map;

    public TypedValueMap() {
        this(new HashMap<String, TypedValue>());
    }

    public TypedValueMap(Map<String, TypedValue> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(new TypedValue(value));
    }

    @Override
    public Object get(Object key) {
        TypedValue value = this.map.get(key);
        return value != null ? value.getObject() : null;
    }

    @Override
    public Object put(String key, Object value) {
        Object old = this.get(key);
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, new TypedValue(value));
        }
        return old;
    }

    @Override
    public Object remove(Object key) {
        Object old = this.get(key);
        this.map.remove(key);
        return old;
    }

    @Override
    public void putAll(Map<? extends String, ?> t) {
        for (Map.Entry<String, ?> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new EntrySet();
    }

    public static Map<String, TypedValue> create(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, TypedValue> result = new HashMap<String, TypedValue>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), new TypedValue(entry.getValue()));
        }
        return result;
    }

    private static class EntrySetIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<Map.Entry<String, TypedValue>> iterator;

        public EntrySetIterator(Iterator<Map.Entry<String, TypedValue>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Map.Entry<String, TypedValue> entry = this.iterator.next();
            return new DefaultMapEntry((Object)entry.getKey(), entry.getValue().getObject());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntrySetIterator(TypedValueMap.this.map.entrySet().iterator());
        }

        @Override
        public int size() {
            return TypedValueMap.this.map.entrySet().size();
        }
    }

    private static class ValueIterator
    implements Iterator<Object> {
        private final Iterator<TypedValue> iterator;

        public ValueIterator(Iterator<TypedValue> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            return this.iterator.next().getObject();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private class ValueCollection
    extends AbstractCollection<Object> {
        private ValueCollection() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator(TypedValueMap.this.map.values().iterator());
        }

        @Override
        public int size() {
            return TypedValueMap.this.map.size();
        }
    }
}

