/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.datatypes.basic;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;
import org.openvpms.component.business.domain.im.datatypes.basic.TypedValueConverter;

public class TypedValue {
    private String type;
    private String value;
    private Object object;
    private State state;

    public TypedValue() {
    }

    public TypedValue(Object object) {
        this.setObject(object);
    }

    public TypedValue(String type, String value) {
        this.type = type;
        this.setValue(value);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        if (this.state == State.OBJECT_DIRTY) {
            this.value = TypedValueConverter.toString(this.object);
            this.state = null;
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.state = State.VALUE_DIRTY;
    }

    public Object getObject() {
        if (this.state == State.VALUE_DIRTY) {
            this.object = TypedValueConverter.fromString(this.value, this.type);
            this.state = null;
        }
        return this.object;
    }

    public void setObject(Object object) {
        if (object != null && object.getClass() == Date.class) {
            object = new Timestamp(((Date)object).getTime());
        }
        this.object = object;
        this.type = TypedValueConverter.getType(object);
        this.state = State.OBJECT_DIRTY;
    }

    public int hashCode() {
        int hash = 0;
        if (this.type != null) {
            hash = this.type.hashCode();
        }
        this.getValue();
        if (this.value != null) {
            hash += this.value.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        TypedValue other;
        boolean equals = super.equals(obj);
        if (!equals && obj instanceof TypedValue && Objects.equals(this.type, (other = (TypedValue)obj).getType()) && Objects.equals(this.getValue(), other.getValue())) {
            equals = true;
        }
        return equals;
    }

    private static enum State {
        OBJECT_DIRTY,
        VALUE_DIRTY;

    }
}

