/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.common;

import java.util.Date;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.system.common.util.DateHelper;

public abstract class PeriodRelationship
extends IMObjectRelationship
implements org.openvpms.component.model.object.PeriodRelationship {
    private Date activeEndTime;
    private Date activeStartTime;

    protected PeriodRelationship() {
    }

    protected PeriodRelationship(ArchetypeId archetypeId) {
        super(archetypeId);
    }

    public Date getActiveStartTime() {
        return this.activeStartTime;
    }

    public void setActiveStartTime(Date time) {
        this.activeStartTime = time;
    }

    public Date getActiveEndTime() {
        return this.activeEndTime;
    }

    public void setActiveEndTime(Date time) {
        this.activeEndTime = time;
    }

    @Override
    public boolean isActive() {
        return this.isActive(new Date());
    }

    public boolean isActive(Date time) {
        return DateHelper.between(time, this.activeStartTime, this.activeEndTime);
    }

    public boolean isActive(long time) {
        return this.isActive(new Date(time));
    }

    public boolean isActive(Date from, Date to) {
        return DateHelper.intersects(from, to, this.activeStartTime, this.activeEndTime);
    }

    @Override
    public void setActive(boolean active) {
        this.activeEndTime = active ? null : new Date();
    }
}

