/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.common;

import java.io.Serializable;
import java.util.Objects;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.Reference;

public class IMObjectReference
implements Reference,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    private ArchetypeId archetypeId;
    private long id = -1L;
    private String linkId;
    private transient int hashCode;

    protected IMObjectReference() {
    }

    public IMObjectReference(IMObject object) {
        if (object == null) {
            throw new IllegalArgumentException("Invalid argument 'object'");
        }
        this.archetypeId = object.getArchetypeId();
        this.setId(object.getId());
        this.setLinkId(object.getLinkId());
    }

    public IMObjectReference(String shortName, long id) {
        this(new ArchetypeId(shortName), id, null);
    }

    public IMObjectReference(ArchetypeId archetypeId, long id) {
        this(archetypeId, id, null);
    }

    public IMObjectReference(String shortName, long id, String linkId) {
        if (shortName == null) {
            throw new IllegalArgumentException("Invalid argument 'shortName'");
        }
        this.archetypeId = new ArchetypeId(shortName);
        this.setId(id);
        this.setLinkId(linkId);
    }

    public IMObjectReference(ArchetypeId archetypeId, long id, String linkId) {
        if (archetypeId == null) {
            throw new IllegalArgumentException("Invalid argument 'archetypeId'");
        }
        this.archetypeId = archetypeId;
        this.setId(id);
        this.setLinkId(linkId);
    }

    public IMObjectReference(ArchetypeId archetypeId, String linkId) {
        if (archetypeId == null) {
            throw new IllegalArgumentException("Invalid argument 'archetypeId'");
        }
        this.archetypeId = archetypeId;
        this.setLinkId(linkId);
    }

    public String getArchetype() {
        return this.archetypeId != null ? this.archetypeId.getShortName() : null;
    }

    public ArchetypeId getArchetypeId() {
        return this.archetypeId;
    }

    public long getId() {
        return this.id;
    }

    public boolean isNew() {
        return this.id == -1L;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IMObjectReference) {
            IMObjectReference rhs = (IMObjectReference)obj;
            if (Objects.equals(this.linkId, rhs.linkId)) {
                equal = Objects.equals(this.archetypeId, rhs.archetypeId);
            }
        }
        return equal;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.archetypeId.getShortName() + ':' + this.id + (this.linkId != null ? ':' + this.linkId : "");
    }

    public boolean isA(String archetype) {
        return TypeHelper.isA((Reference)this, archetype);
    }

    public boolean isA(String ... archetypes) {
        return TypeHelper.isA((Reference)this, archetypes);
    }

    public boolean equals(String archetype, String linkId) {
        return Objects.equals(this.linkId, linkId) && Objects.equals(this.getArchetype(), archetype);
    }

    public boolean equals(String archetype, long id) {
        return this.id == id && Objects.equals(this.getArchetype(), archetype);
    }

    public static IMObjectReference fromString(String value) {
        IMObjectReference result = null;
        if (value != null) {
            String id;
            int first = value.indexOf(58);
            if (first == -1) {
                throw new IllegalArgumentException("Invalid object reference: " + value);
            }
            String shortName = value.substring(0, first);
            int second = value.indexOf(58, first + 1);
            String linkId = null;
            if (second != -1) {
                id = value.substring(first + 1, second);
                linkId = value.substring(second + 1);
            } else {
                id = value.substring(first + 1);
            }
            try {
                result = new IMObjectReference(shortName, Long.parseLong(id), linkId);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Invalid object reference: " + value);
            }
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void setArchetypeId(ArchetypeId archetypeId) {
        this.archetypeId = archetypeId;
    }

    protected void setId(long id) {
        this.id = id;
        this.updateHash();
    }

    protected void setLinkId(String linkId) {
        this.linkId = linkId;
        this.updateHash();
    }

    private void updateHash() {
        this.hashCode = this.linkId != null ? this.linkId.hashCode() : Objects.hash(this.getArchetype(), this.getId());
    }
}

