/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.StandardToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.system.service.uuid.JUGGenerator;

public class IMObject
implements org.openvpms.component.model.object.IMObject,
Serializable,
Cloneable {
    protected static final StandardToStringStyle STYLE;
    private long id = -1L;
    private boolean active = true;
    private ArchetypeId archetypeId;
    private String description;
    private String linkId;
    private String name;
    private long version;
    private Map<String, Object> details = new HashMap<String, Object>();
    private static final long serialVersionUID = 2L;
    private static final JUGGenerator generator;

    public IMObject() {
    }

    public IMObject(ArchetypeId archetypeId) {
        this.archetypeId = archetypeId;
        if (this.archetypeId != null) {
            this.description = archetypeId.getConcept();
        }
    }

    public IMObject(ArchetypeId archetypeId, String name, String description) {
        this(archetypeId);
        this.name = name;
        this.description = description;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Object clone() throws CloneNotSupportedException {
        IMObject copy = (IMObject)super.clone();
        copy.linkId = this.getLinkId();
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof org.openvpms.component.model.object.IMObject) {
            org.openvpms.component.model.object.IMObject rhs = (org.openvpms.component.model.object.IMObject)obj;
            return this.getObjectReference().equals(rhs.getObjectReference());
        }
        return false;
    }

    public String getArchetype() {
        ArchetypeId result = this.getArchetypeId();
        return result != null ? result.getShortName() : null;
    }

    public ArchetypeId getArchetypeId() {
        return this.archetypeId;
    }

    public String getArchetypeIdAsString() {
        return this.archetypeId == null ? null : this.archetypeId.getQualifiedName();
    }

    public IMObjectReference getObjectReference() {
        return new IMObjectReference(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getLinkId() {
        if (this.linkId == null) {
            this.linkId = generator.nextId();
        }
        return this.linkId;
    }

    public String getName() {
        return this.name;
    }

    public long getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.getLinkId().hashCode();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isNew() {
        return this.id == -1L;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, Object> details) {
        this.details = details;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setArchetypeId(ArchetypeId archetypeId) {
        this.archetypeId = archetypeId;
    }

    public void setArchetypeIdAsString(String archId) {
        this.archetypeId = new ArchetypeId(archId);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)STYLE).append("id", this.id).append("archetypeId", (Object)this.archetypeId).append("linkId", (Object)this.getLinkId()).append("version", this.version).append("name", (Object)this.name).toString();
    }

    public boolean isA(String archetype) {
        return TypeHelper.isA((org.openvpms.component.model.object.IMObject)this, archetype);
    }

    public boolean isA(String ... archetypes) {
        return TypeHelper.isA((org.openvpms.component.model.object.IMObject)this, archetypes);
    }

    public boolean isA(Collection<String> archetypes) {
        return TypeHelper.isA((org.openvpms.component.model.object.IMObject)this, archetypes);
    }

    static {
        generator = new JUGGenerator();
        STYLE = new StandardToStringStyle();
        STYLE.setUseShortClassName(true);
        STYLE.setUseIdentityHashCode(false);
    }
}

