/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.archetype.descriptor;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionException;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.Descriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.datatypes.property.NamedProperty;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyMap;
import org.springframework.beans.factory.BeanFactory;

public class AssertionDescriptor
extends Descriptor
implements org.openvpms.component.model.archetype.AssertionDescriptor {
    private String errorMessage;
    private int index;
    private PropertyMap propertyMap = new PropertyMap("root");
    private transient AssertionTypeDescriptor descriptor;
    private transient BeanFactory beans;
    private static final long serialVersionUID = 1L;

    public AssertionDescriptor() {
        this.setArchetypeId(new ArchetypeId("descriptor.assertion.1.0"));
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public PropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(PropertyMap propertyMap) {
        this.propertyMap = propertyMap;
    }

    public void addProperty(org.openvpms.component.model.archetype.NamedProperty property) {
        this.propertyMap.getProperties().put(property.getName(), property);
    }

    public void removeProperty(org.openvpms.component.model.archetype.NamedProperty property) {
        this.propertyMap.getProperties().remove(property.getName());
    }

    public void removeProperty(String name) {
        this.propertyMap.getProperties().remove(name);
    }

    public org.openvpms.component.model.archetype.NamedProperty getProperty(String name) {
        return this.propertyMap.getProperties().get(name);
    }

    public NamedProperty[] getPropertiesAsArray() {
        return this.propertyMap.getProperties().values().toArray(new NamedProperty[0]);
    }

    public void setPropertiesAsArray(NamedProperty[] properties) {
        this.propertyMap = new PropertyMap("root");
        for (NamedProperty property : properties) {
            this.propertyMap.getProperties().put(property.getName(), property);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)STYLE);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AssertionDescriptor copy = (AssertionDescriptor)super.clone();
        if (this.propertyMap != null) {
            copy.propertyMap = (PropertyMap)this.propertyMap.clone();
        }
        return copy;
    }

    public AssertionTypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(AssertionTypeDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setBeans(BeanFactory beans) {
        this.beans = beans;
    }

    public void create(Object target, NodeDescriptor node) {
        if (this.descriptor == null) {
            throw new AssertionException(AssertionException.ErrorCode.NoAssertionTypeSpecified, new Object[]{this.getName(), node.getName()});
        }
        this.descriptor.create(target, node, this, this.beans);
    }

    public boolean validate(Object value, org.openvpms.component.model.object.IMObject parent, org.openvpms.component.model.archetype.NodeDescriptor node) {
        if (this.descriptor == null) {
            throw new AssertionException(AssertionException.ErrorCode.NoAssertionTypeSpecified, new Object[]{this.getName(), node.getName()});
        }
        return this.descriptor.validate(value, (IMObject)parent, (NodeDescriptor)node, this, this.beans);
    }

    public Object set(Object value, IMObject parent, NodeDescriptor node) {
        if (this.descriptor == null) {
            throw new AssertionException(AssertionException.ErrorCode.NoAssertionTypeSpecified, new Object[]{this.getName(), node.getName()});
        }
        return this.descriptor.set(value, parent, node, this, this.beans);
    }
}

