/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.archetype.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.archetype.ReadOnlyArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.Descriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorException;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorValidationError;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.archetype.Units;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.Reference;

public class ArchetypeDescriptor
extends Descriptor
implements org.openvpms.component.model.archetype.ArchetypeDescriptor,
AuditableIMObject {
    private ArchetypeId type;
    private String displayName;
    private String className;
    private Class<?> clazz;
    private boolean isLatest;
    private boolean primary = true;
    private boolean singleton;
    private Date created;
    private Reference createdBy;
    private Date updated;
    private Reference updatedBy;
    private Map<String, org.openvpms.component.model.archetype.NodeDescriptor> nodeDescriptors = new LinkedHashMap<String, org.openvpms.component.model.archetype.NodeDescriptor>();
    private static final long serialVersionUID = 2L;
    private static final ArchetypeId ARCHETYPE_ID = new ReadOnlyArchetypeId("descriptor.archetype.1.0");

    public ArchetypeDescriptor() {
        this.setArchetypeId(ARCHETYPE_ID);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.type = StringUtils.isEmpty((CharSequence)name) ? null : new ArchetypeId(name);
    }

    public String getArchetypeType() {
        return this.type == null ? null : this.type.getShortName();
    }

    public ArchetypeId getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Class<?> getClassType() {
        return this.getClazz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClazz() {
        if (this.clazz == null) {
            ArchetypeDescriptor archetypeDescriptor = this;
            synchronized (archetypeDescriptor) {
                this.clazz = this.getClass(this.className);
            }
        }
        return this.clazz;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public void setLatest(boolean isLatest) {
        this.isLatest = isLatest;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Reference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(Reference createdBy) {
        this.createdBy = createdBy;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public Reference getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(Reference updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void addNodeDescriptor(org.openvpms.component.model.archetype.NodeDescriptor node) {
        if (this.nodeDescriptors.containsKey(node.getName())) {
            throw new DescriptorException(DescriptorException.ErrorCode.DuplicateNodeDescriptor, node.getName(), this.getName());
        }
        NodeDescriptor descriptor = (NodeDescriptor)node;
        this.nodeDescriptors.put(node.getName(), descriptor);
        descriptor.setArchetypeDescriptor(this);
    }

    public void removeNodeDescriptor(org.openvpms.component.model.archetype.NodeDescriptor node) {
        NodeDescriptor removed = (NodeDescriptor)this.nodeDescriptors.remove(node.getName());
        if (removed != null) {
            removed.setArchetypeDescriptor(null);
        }
    }

    public void removeNodeDescriptor(String nodeName) {
        this.removeNodeDescriptorWithName(this.getNodeDescriptorMap(), nodeName);
    }

    public NodeDescriptor[] getNodeDescriptorsAsArray() {
        return this.nodeDescriptors.values().toArray(new NodeDescriptor[0]);
    }

    public List<NodeDescriptor> getSimpleNodeDescriptors() {
        List<NodeDescriptor> all = this.getAllNodeDescriptors();
        ArrayList<NodeDescriptor> simple = new ArrayList<NodeDescriptor>();
        for (NodeDescriptor node : all) {
            if (node.isComplexNode()) continue;
            simple.add(node);
        }
        return simple;
    }

    public List<NodeDescriptor> getComplexNodeDescriptors() {
        List<NodeDescriptor> all = this.getAllNodeDescriptors();
        ArrayList<NodeDescriptor> complex = new ArrayList<NodeDescriptor>();
        for (NodeDescriptor node : all) {
            if (!node.isComplexNode()) continue;
            complex.add(node);
        }
        return complex;
    }

    public List<org.openvpms.component.model.archetype.NodeDescriptor> getNodeDescriptors() {
        return this.getAllNodeDescriptors();
    }

    public List<NodeDescriptor> getAllNodeDescriptors() {
        ArrayList<NodeDescriptor> nodes = new ArrayList<NodeDescriptor>();
        this.getAllNodeDescriptors(this.getNodeDescriptorsAsArray(), nodes);
        return nodes;
    }

    public Map<String, org.openvpms.component.model.archetype.NodeDescriptor> getNodeDescriptorMap() {
        return this.nodeDescriptors;
    }

    public void setNodeDescriptorsAsArray(NodeDescriptor[] nodes) {
        this.nodeDescriptors = new LinkedHashMap<String, org.openvpms.component.model.archetype.NodeDescriptor>();
        int index = 0;
        for (NodeDescriptor node : nodes) {
            node.setIndex(index++);
            this.addNodeDescriptor(node);
        }
    }

    public String getShortName() {
        return this.type == null ? null : this.type.getShortName();
    }

    public String getDisplayName() {
        return StringUtils.isEmpty((CharSequence)this.displayName) ? this.getShortName() : this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public NodeDescriptor getNodeDescriptor(String name) {
        return this.findNodeDescriptorWithName(this.getNodeDescriptorsAsArray(), name);
    }

    public List<DescriptorValidationError> validate() {
        ArrayList<DescriptorValidationError> errors = new ArrayList<DescriptorValidationError>();
        if (this.type == null) {
            errors.add(new DescriptorValidationError(Descriptor.DescriptorType.ArchetypeDescriptor, null, "type", Descriptor.ValidationError.IsRequired));
        }
        if (StringUtils.isEmpty((CharSequence)this.className)) {
            errors.add(new DescriptorValidationError(Descriptor.DescriptorType.ArchetypeDescriptor, null, "className", Descriptor.ValidationError.IsRequired));
        }
        List<NodeDescriptor> nodes = this.getAllNodeDescriptors();
        HashMap<String, NodeDescriptor> names = new HashMap<String, NodeDescriptor>();
        for (NodeDescriptor node : nodes) {
            if (names.containsKey(node.getName())) {
                errors.add(new DescriptorValidationError(Descriptor.DescriptorType.NodeDescriptor, node.getName(), "name", Descriptor.ValidationError.DuplicateNodeDescriptor));
            }
            names.put(node.getName(), node);
            Units units = node.getUnits();
            if (units == null || units.getNode() == null || this.getNodeDescriptor(units.getNode()) != null) continue;
            errors.add(new DescriptorValidationError(Descriptor.DescriptorType.NodeDescriptor, node.getName(), "units.node", Descriptor.ValidationError.NodeNotFound));
        }
        return errors;
    }

    @Override
    public int hashCode() {
        return this.type != null ? this.type.hashCode() : super.hashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)STYLE).appendSuper(super.toString()).append("type", (Object)this.type).append("displayName", (Object)this.displayName).append("className", (Object)this.className).append("isLatest", this.isLatest).append("primary", this.primary).append("nodeDescriptors", this.nodeDescriptors).toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArchetypeDescriptor copy = (ArchetypeDescriptor)super.clone();
        copy.nodeDescriptors = new LinkedHashMap<String, org.openvpms.component.model.archetype.NodeDescriptor>(this.nodeDescriptors);
        copy.primary = this.primary;
        copy.type = (ArchetypeId)(this.type == null ? null : this.type.clone());
        return copy;
    }

    protected void setType(ArchetypeId type) {
        this.type = type;
    }

    private NodeDescriptor findNodeDescriptorWithName(NodeDescriptor[] nodes, String name) {
        for (NodeDescriptor node : nodes) {
            NodeDescriptor result;
            if (node.getName().equals(name)) {
                return node;
            }
            if (node.getNodeDescriptorsAsArray().length <= 0 || (result = this.findNodeDescriptorWithName(node.getNodeDescriptorsAsArray(), name)) == null) continue;
            return result;
        }
        return null;
    }

    private boolean removeNodeDescriptorWithName(Map<String, org.openvpms.component.model.archetype.NodeDescriptor> nodes, String nodeName) {
        if (nodes.remove(nodeName) != null) {
            return true;
        }
        for (org.openvpms.component.model.archetype.NodeDescriptor n : nodes.values()) {
            Map<String, org.openvpms.component.model.archetype.NodeDescriptor> map;
            NodeDescriptor node = (NodeDescriptor)n;
            if (node.getNodeDescriptors().size() <= 0 || !this.removeNodeDescriptorWithName(map = node.getNodeDescriptors(), nodeName)) continue;
            return true;
        }
        return false;
    }

    private void getAllNodeDescriptors(NodeDescriptor[] nodes, List<NodeDescriptor> result) {
        Arrays.sort(nodes, new NodeDescriptorIndexComparator());
        for (NodeDescriptor node : nodes) {
            result.add(node);
            if (node.getNodeDescriptorsAsArray().length <= 0) continue;
            this.getAllNodeDescriptors(node.getNodeDescriptorsAsArray(), result);
        }
    }

    private static class NodeDescriptorIndexComparator
    implements Comparator<NodeDescriptor> {
        private NodeDescriptorIndexComparator() {
        }

        @Override
        public int compare(NodeDescriptor no1, NodeDescriptor no2) {
            if (no1 == no2) {
                return 0;
            }
            return Integer.compare(no1.getIndex(), no2.getIndex());
        }
    }
}

