/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.act;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.business.domain.im.act.ActIdentity;
import org.openvpms.component.business.domain.im.common.AuditableIMObject;
import org.openvpms.component.business.domain.im.common.EntityException;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.object.Reference;

public class Act
extends AuditableIMObject
implements org.openvpms.component.model.act.Act {
    private String title;
    private Date activityStartTime;
    private Date activityEndTime;
    private String reason;
    private String status;
    private String status2;
    private Set<org.openvpms.component.model.act.ActIdentity> identities = new HashSet<org.openvpms.component.model.act.ActIdentity>();
    private Set<Participation> participations = new HashSet<Participation>();
    private Set<ActRelationship> sourceActRelationships = new HashSet<ActRelationship>();
    private Set<ActRelationship> targetActRelationships = new HashSet<ActRelationship>();
    private static final long serialVersionUID = 5L;

    public Date getActivityEndTime() {
        return this.activityEndTime;
    }

    public void setActivityEndTime(Date time) {
        this.activityEndTime = time;
    }

    public Date getActivityStartTime() {
        return this.activityStartTime;
    }

    public void setActivityStartTime(Date time) {
        this.activityStartTime = time;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus2() {
        return this.status2;
    }

    public void setStatus2(String status2) {
        this.status2 = status2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addIdentity(org.openvpms.component.model.act.ActIdentity identity) {
        ((ActIdentity)identity).setAct(this);
        this.identities.add(identity);
    }

    public void removeIdentity(org.openvpms.component.model.act.ActIdentity identity) {
        ((ActIdentity)identity).setAct(null);
        this.identities.remove(identity);
    }

    public Set<org.openvpms.component.model.act.ActIdentity> getIdentities() {
        return this.identities;
    }

    public Set<ActRelationship> getSourceActRelationships() {
        return this.sourceActRelationships;
    }

    public void setSourceActRelationships(Set<ActRelationship> sourceActRelationships) {
        this.sourceActRelationships = sourceActRelationships;
    }

    public void addSourceActRelationship(ActRelationship relationship) {
        this.sourceActRelationships.add(relationship);
    }

    public void removeSourceActRelationship(ActRelationship relationship) {
        this.sourceActRelationships.remove(relationship);
    }

    public Set<ActRelationship> getTargetActRelationships() {
        return this.targetActRelationships;
    }

    public void setTargetActRelationships(Set<ActRelationship> targetActRelationships) {
        this.targetActRelationships = targetActRelationships;
    }

    public void addTargetActRelationship(ActRelationship relationship) {
        this.targetActRelationships.add(relationship);
    }

    public void removeTargetActRelationship(ActRelationship relationship) {
        this.targetActRelationships.remove(relationship);
    }

    public void addActRelationship(ActRelationship relationship) {
        if (relationship.getSource().getLinkId().equals(this.getLinkId()) && relationship.getSource().getArchetype().equals(this.getArchetype())) {
            this.addSourceActRelationship(relationship);
        } else if (relationship.getTarget().getLinkId().equals(this.getLinkId()) && relationship.getTarget().getArchetype().equals(this.getArchetype())) {
            this.addTargetActRelationship(relationship);
        } else {
            throw new EntityException(EntityException.ErrorCode.FailedToAddActRelationship, new Object[]{relationship.getSource(), relationship.getTarget()});
        }
    }

    public void removeActRelationship(ActRelationship relationship) {
        Reference source = relationship.getSource();
        Reference target = relationship.getTarget();
        if (source.getLinkId().equals(this.getLinkId()) && source.getArchetype().equals(this.getArchetype())) {
            this.removeSourceActRelationship(relationship);
        } else if (target.getLinkId().equals(this.getLinkId()) && target.getArchetype().equals(this.getArchetype())) {
            this.removeTargetActRelationship(relationship);
        } else {
            throw new EntityException(EntityException.ErrorCode.FailedToRemoveActRelationship, new Object[]{source, target});
        }
    }

    public Set<ActRelationship> getActRelationships() {
        HashSet<ActRelationship> relationships = new HashSet<ActRelationship>(this.sourceActRelationships);
        relationships.addAll(this.targetActRelationships);
        return relationships;
    }

    public Set<Participation> getParticipations() {
        return this.participations;
    }

    public void setParticipations(Set<Participation> participations) {
        this.participations = participations;
    }

    public void addParticipation(Participation participation) {
        this.participations.add(participation);
    }

    public void removeParticipation(Participation participation) {
        this.participations.remove(participation);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Act copy = (Act)super.clone();
        copy.identities = new HashSet<org.openvpms.component.model.act.ActIdentity>(this.identities);
        copy.participations = new HashSet<Participation>(this.participations);
        copy.sourceActRelationships = new HashSet<ActRelationship>(this.sourceActRelationships);
        copy.targetActRelationships = new HashSet<ActRelationship>(this.targetActRelationships);
        return copy;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)STYLE).appendSuper(super.toString()).append("title", (Object)this.title).append("activityStartTime", (Object)this.activityStartTime).append("activityEndTime", (Object)this.activityEndTime).append("reason", (Object)this.reason).append("status", (Object)this.status).append("identities", this.identities).append("participations", this.participations).append("sourceActRelationships", this.sourceActRelationships).append("targetActRelationships", this.targetActRelationships).toString();
    }
}

