/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.security;

import java.util.Arrays;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.openvpms.component.business.dao.hibernate.cache.ArchetypeIdCache;
import org.openvpms.component.business.dao.hibernate.im.common.CompoundAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityLinkAssembler;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityRelationshipAssembler;
import org.openvpms.component.business.dao.hibernate.im.entity.IMObjectResultCollector;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupAssembler;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupLinkAssembler;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupRelationshipAssembler;
import org.openvpms.component.business.dao.hibernate.im.party.ContactAssembler;
import org.openvpms.component.business.dao.hibernate.im.security.ArchetypeAuthorityAssembler;
import org.openvpms.component.business.dao.hibernate.im.security.SecurityRoleAssembler;
import org.openvpms.component.business.dao.hibernate.im.security.UserAssembler;
import org.openvpms.component.business.dao.hibernate.im.security.UserDO;
import org.openvpms.component.business.dao.hibernate.im.security.UserDOImpl;
import org.openvpms.component.business.dao.im.security.IUserDAO;
import org.openvpms.component.business.dao.im.security.UserDAOException;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.springframework.transaction.annotation.Transactional;

public class UserDAOHibernate
implements IUserDAO {
    private final SessionFactory factory;
    private final ArchetypeIdCache archetypeIds;
    private final CompoundAssembler assembler;
    private List<String> archetypes;
    private static final String DEFAULT_QUERY;
    private static final String QUERY_BY_ARCHETYPE;

    public UserDAOHibernate(SessionFactory factory, IArchetypeDescriptorCache archetypes) {
        this(factory, archetypes, new ArchetypeIdCache());
    }

    public UserDAOHibernate(SessionFactory factory, IArchetypeDescriptorCache archetypes, ArchetypeIdCache archetypeIds) {
        this.factory = factory;
        this.archetypeIds = archetypeIds;
        this.assembler = new Assembler(archetypes);
    }

    public void setUserArchetypes(String ... archetypes) {
        this.archetypes = archetypes != null && archetypes.length > 0 ? Arrays.asList(archetypes) : null;
    }

    @Override
    @Transactional(readOnly=true)
    public User getUser(String username) {
        List results;
        Session session = this.factory.getCurrentSession();
        try {
            boolean byArchetype = this.archetypes != null && !this.archetypes.isEmpty();
            String userQuery = byArchetype ? QUERY_BY_ARCHETYPE : DEFAULT_QUERY;
            Query query = session.createQuery(userQuery, UserDO.class);
            query.setParameter("username", (Object)username);
            if (byArchetype) {
                query.setParameter("archetypes", this.archetypes);
            }
            Context context = Context.getContext(session, this.assembler, this.archetypeIds);
            IMObjectResultCollector collector = new IMObjectResultCollector();
            collector.setContext(context);
            query.stream().findFirst().ifPresent(collector::collect);
            context.resolveDeferredReferences();
            results = collector.getPage().getResults();
        }
        catch (Exception exception) {
            throw new UserDAOException(UserDAOException.ErrorCode.FailedToFindUserRecordByName, new Object[]{username}, exception);
        }
        return !results.isEmpty() ? (User)results.get(0) : null;
    }

    static {
        String prefix = "from " + UserDOImpl.class.getName() + " as user where user.username = :username";
        String suffix = " order by user.id";
        DEFAULT_QUERY = prefix + suffix;
        QUERY_BY_ARCHETYPE = prefix + " and user.archetypeId.shortName in (:archetypes)" + suffix;
    }

    private static class Assembler
    extends CompoundAssembler {
        Assembler(IArchetypeDescriptorCache archetypes) {
            super(archetypes);
            this.addAssembler(new ArchetypeAuthorityAssembler());
            this.addAssembler(new EntityLinkAssembler());
            this.addAssembler(new EntityRelationshipAssembler());
            this.addAssembler(new LookupAssembler());
            this.addAssembler(new LookupRelationshipAssembler());
            this.addAssembler(new LookupLinkAssembler());
            this.addAssembler(new SecurityRoleAssembler());
            this.addAssembler(new UserAssembler());
            this.addAssembler(new ContactAssembler());
        }
    }
}

