/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.security;

import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.SetAssembler;
import org.openvpms.component.business.dao.hibernate.im.security.ArchetypeAuthorityDO;
import org.openvpms.component.business.dao.hibernate.im.security.SecurityRoleDO;
import org.openvpms.component.business.dao.hibernate.im.security.SecurityRoleDOImpl;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.SecurityRole;

public class SecurityRoleAssembler
extends AuditableIMObjectAssembler<SecurityRole, SecurityRoleDO> {
    private static final SetAssembler<ArchetypeAwareGrantedAuthority, ArchetypeAuthorityDO> AUTHS = SetAssembler.create(ArchetypeAwareGrantedAuthority.class, ArchetypeAuthorityDO.class, true);

    public SecurityRoleAssembler() {
        super(null, SecurityRole.class, SecurityRoleDO.class, SecurityRoleDOImpl.class);
    }

    @Override
    protected void assembleDO(SecurityRoleDO target, SecurityRole source, DOState state, Context context) {
        super.assembleDO(target, source, state, context);
        AUTHS.assembleDO(target.getAuthorities(), source.getAuthorities(), state, context);
    }

    @Override
    protected void assembleObject(SecurityRole target, SecurityRoleDO source, Context context) {
        super.assembleObject(target, source, context);
        AUTHS.assembleObject(target.getAuthorities(), source.getAuthorities(), context);
    }

    @Override
    protected SecurityRole create(SecurityRoleDO object) {
        return new SecurityRole();
    }

    @Override
    protected SecurityRoleDO create(SecurityRole object) {
        return new SecurityRoleDOImpl();
    }
}

