/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.business.dao.hibernate.im.common.CompoundAssembler;
import org.openvpms.component.business.dao.hibernate.im.query.QueryBuilderException;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.common.AuditableIMObject;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.system.common.query.ArchetypeConstraint;
import org.openvpms.component.system.common.query.ArchetypeIdConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.springframework.util.ClassUtils;

public class TypeSet {
    private final Set<org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors;
    private final String className;
    private String alias;

    private TypeSet(String alias, Set<org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors, CompoundAssembler assembler) {
        this.alias = alias;
        Class<?> baseType = TypeSet.getClass(descriptors);
        this.className = assembler.getDOClassName(baseType.getName());
        this.descriptors = descriptors;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<org.openvpms.component.model.archetype.ArchetypeDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public boolean contains(TypeSet other) {
        return Objects.equals(this.alias, other.alias) && this.getShortNames().containsAll(other.getShortNames());
    }

    public Set<String> getShortNames() {
        HashSet<String> result = new HashSet<String>();
        for (org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor : this.descriptors) {
            result.add(descriptor.getArchetypeType());
        }
        return result;
    }

    public static TypeSet create(ArchetypeIdConstraint constraint, IArchetypeDescriptorCache cache, CompoundAssembler assembler) {
        ArchetypeId id = constraint.getArchetypeId();
        ArchetypeDescriptor descriptor = cache.getArchetypeDescriptor(id);
        if (descriptor == null) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoArchetypesForId, id);
        }
        HashSet<org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = new HashSet<org.openvpms.component.model.archetype.ArchetypeDescriptor>();
        descriptors.add(descriptor);
        return new TypeSet(constraint.getAlias(), descriptors, assembler);
    }

    public static TypeSet create(ArchetypeConstraint constraint, List<NodeDescriptor> nodes, IArchetypeDescriptorCache cache, CompoundAssembler assembler) {
        HashSet<String> matches = new HashSet<String>();
        for (NodeDescriptor descriptor : nodes) {
            TypeSet.mergeArchetypeRange(matches, descriptor);
        }
        String[] shortNames = matches.toArray(new String[0]);
        Set<org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = TypeSet.getDescriptors(shortNames, constraint.isPrimaryOnly(), cache);
        if (descriptors.isEmpty()) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoMatchingArchetypesForShortName, ArrayUtils.toString((Object)shortNames));
        }
        return new TypeSet(constraint.getAlias(), descriptors, assembler);
    }

    public static TypeSet create(ShortNameConstraint constraint, IArchetypeDescriptorCache cache, CompoundAssembler assembler) {
        Set<org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = TypeSet.getDescriptors(constraint.getShortNames(), constraint.isPrimaryOnly(), cache);
        if (descriptors.isEmpty()) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoMatchingArchetypesForShortName, ArrayUtils.toString((Object)constraint.getShortNames()));
        }
        return new TypeSet(constraint.getAlias(), descriptors, assembler);
    }

    public static Class<?> getClass(Collection<org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors) {
        Class superType = null;
        if (descriptors.isEmpty()) {
            throw new IllegalArgumentException("Argument 'descriptors' cannot be empty");
        }
        for (org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor : descriptors) {
            Class type = descriptor.getClassType();
            if (superType == null) {
                superType = type;
                continue;
            }
            Class newSuperType = ClassUtils.determineCommonAncestor((Class)type, (Class)superType);
            if (IMObject.class.equals((Object)newSuperType) || AuditableIMObject.class.equals((Object)newSuperType)) {
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.CannotQueryAcrossTypes, superType, descriptor.getClassName());
            }
            superType = newSuperType;
        }
        return superType;
    }

    private static Set<org.openvpms.component.model.archetype.ArchetypeDescriptor> getDescriptors(String[] shortNames, boolean primaryOnly, IArchetypeDescriptorCache cache) {
        HashSet<String> expanded = new HashSet<String>();
        for (String shortName : shortNames) {
            List<String> matches = cache.getArchetypeShortNames(shortName, primaryOnly);
            expanded.addAll(matches);
        }
        return TypeSet.getDescriptors(expanded.toArray(new String[0]), cache);
    }

    private static Set<org.openvpms.component.model.archetype.ArchetypeDescriptor> getDescriptors(String[] shortNames, IArchetypeDescriptorCache cache) {
        HashSet<org.openvpms.component.model.archetype.ArchetypeDescriptor> result = new HashSet<org.openvpms.component.model.archetype.ArchetypeDescriptor>();
        for (String shortName : shortNames) {
            ArchetypeDescriptor descriptor = cache.getArchetypeDescriptor(shortName);
            result.add(descriptor);
        }
        return result;
    }

    private static void mergeArchetypeRange(Set<String> matches, NodeDescriptor descriptor) {
        String[] shortNames = descriptor.getArchetypeRange();
        if (shortNames == null || shortNames.length == 0) {
            if (descriptor.getFilter() == null) {
                org.openvpms.component.model.archetype.ArchetypeDescriptor archetype = descriptor.getArchetypeDescriptor();
                String name = archetype != null ? archetype.getArchetypeType() : "unknown";
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoArchetypeRangeAssertion, name, descriptor.getName());
            }
            matches.add(descriptor.getFilter());
        } else {
            matches.addAll(Arrays.asList(shortNames));
        }
    }
}

