/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.query;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.WordUtils;
import org.openvpms.component.business.dao.hibernate.im.query.QueryBuilderException;
import org.openvpms.component.business.dao.hibernate.im.query.TypeSet;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.RelationalOp;
import org.openvpms.component.system.common.query.SelectConstraint;

public class QueryContext {
    private final QueryContext parent;
    private final boolean distinct;
    private final List<SelectConstraint> selectConstraints = new ArrayList<SelectConstraint>();
    private final List<String> selectClauses = new ArrayList<String>();
    private final List<String> selectNames = new ArrayList<String>();
    private final List<String> refSelectNames = new ArrayList<String>();
    private final Clause whereClause = new Clause();
    private final List<FromClause> fromClauses = new ArrayList<FromClause>();
    private final Deque<FromClause> fromStack = new ArrayDeque<FromClause>();
    private final StringBuilder orderedClause = new StringBuilder(" order by ");
    private final int initOrderedClauseLen = this.orderedClause.length();
    private final Deque<TypeSet> typeStack = new ArrayDeque<TypeSet>();
    private final Map<String, TypeSet> typesets = new LinkedHashMap<String, TypeSet>();
    private final NameAllocator typeNames;
    private final NameAllocator paramNames;
    private final Deque<String> varStack = new ArrayDeque<String>();
    private final Deque<Counter<JoinConstraint.JoinType>> joinStack = new ArrayDeque<Counter<JoinConstraint.JoinType>>();
    private final Map<String, Object> params;
    private String defaultSelect;
    private static final String NOT_CONSTRAINT = "not ";

    QueryContext(boolean distinct, QueryContext parent) {
        this.parent = parent;
        this.distinct = distinct;
        if (parent != null) {
            this.typeNames = parent.typeNames;
            this.paramNames = parent.paramNames;
            this.params = parent.params;
        } else {
            this.typeNames = new NameAllocator();
            this.paramNames = new NameAllocator();
            this.params = new HashMap<String, Object>();
        }
    }

    public String getQueryString() {
        return this.getQueryString(false);
    }

    public String getQueryString(boolean count) {
        StringBuilder result = new StringBuilder("select ");
        if (count) {
            result.append("count (");
        }
        if (this.distinct) {
            result.append("distinct ");
        }
        if (this.selectClauses.isEmpty()) {
            result.append(this.defaultSelect);
        } else if (count && this.selectClauses.size() > 1) {
            if (this.distinct) {
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.CannotCountDistinctMultipleSelect);
            }
            result.append('*');
        } else {
            for (int i = 0; i < this.selectClauses.size(); ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(this.selectClauses.get(i));
            }
        }
        if (count) {
            result.append(')');
        }
        if (!this.fromClauses.isEmpty()) {
            result.append(" from ");
            boolean first = true;
            for (FromClause from : this.fromClauses) {
                if (!first) {
                    if (from.needsComma()) {
                        result.append(", ");
                    } else {
                        result.append(" ");
                    }
                } else {
                    first = false;
                }
                result.append(from);
            }
        }
        if (!this.whereClause.isEmpty()) {
            result.append(" where ").append(this.whereClause);
        }
        if (this.orderedClause.length() != this.initOrderedClauseLen) {
            result.append((CharSequence)this.orderedClause);
        }
        return result.toString();
    }

    public void addSelectConstraint(SelectConstraint select) {
        this.selectConstraints.add(select);
    }

    public List<SelectConstraint> getSelectConstraints() {
        return this.selectConstraints;
    }

    public Map<String, Object> getParameters() {
        return this.params;
    }

    public List<String> getSelectNames() {
        return this.selectNames;
    }

    public List<String> getRefSelectNames() {
        return this.refSelectNames;
    }

    public Map<String, Set<String>> getSelectTypes() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String name : this.selectNames) {
            int index = name.indexOf(".");
            String alias = index == -1 ? name : name.substring(0, index);
            result.computeIfAbsent(alias, s -> {
                TypeSet set = this.typesets.get(alias);
                return set.getShortNames();
            });
        }
        return result;
    }

    void pushLogicalOperator(LogicalOperator op) {
        Clause clause = this.getClause();
        clause.push(op);
    }

    void popLogicalOperator() {
        this.getClause().pop();
    }

    boolean pushTypeSet(TypeSet types) {
        boolean added = this.addTypeSet(types, types.getAlias());
        String alias = types.getAlias();
        if (added) {
            FromClause fromClause;
            boolean first = this.typeStack.isEmpty();
            if (first) {
                fromClause = new FromClause(types.getClassName(), alias);
                this.defaultSelect = alias;
            } else {
                fromClause = new FromClause(JoinConstraint.JoinType.InnerJoin, types.getClassName(), alias);
            }
            this.fromClauses.add(fromClause);
            this.fromStack.push(fromClause);
            this.joinStack.push(new Counter<JoinConstraint.JoinType>(JoinConstraint.JoinType.InnerJoin));
        }
        this.typeStack.push(types);
        this.varStack.push(alias);
        return added;
    }

    QueryContext pushTypeSet(TypeSet types, String property, JoinConstraint.JoinType joinType) {
        if (!this.addTypeSet(types, property)) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.CannotJoinDuplicateAlias, property, types.getAlias());
        }
        String alias = types.getAlias();
        FromClause fromClause = new FromClause(joinType, this.varStack.peek(), property, alias);
        this.fromClauses.add(fromClause);
        this.fromStack.push(fromClause);
        this.typeStack.push(types);
        this.joinStack.push(new Counter<JoinConstraint.JoinType>(joinType));
        this.varStack.push(alias);
        return this;
    }

    void popTypeSet(boolean popJoin) {
        this.varStack.pop();
        this.typeStack.pop();
        if (popJoin) {
            this.joinStack.pop();
            this.fromStack.pop();
        }
    }

    TypeSet peekTypeSet() {
        return this.typeStack.peek();
    }

    TypeSet getPrimarySet() {
        return !this.typesets.isEmpty() ? this.typesets.values().iterator().next() : null;
    }

    boolean isOuterJoin() {
        return !this.joinStack.isEmpty() && this.joinStack.peek().operator != JoinConstraint.JoinType.InnerJoin;
    }

    TypeSet getTypeSet(String alias) {
        TypeSet result = null;
        if (alias != null && this.parent != null) {
            result = this.parent.getTypeSet(alias);
        }
        if (result == null) {
            if (alias != null) {
                result = this.typesets.get(alias);
            } else if (!this.typeStack.isEmpty()) {
                result = this.typeStack.peek();
            }
        }
        return result;
    }

    void addSelectConstraint(String alias, String node, String property) {
        if (alias == null) {
            alias = this.varStack.peek();
        }
        String clause = property == null ? alias : alias + "." + property;
        this.selectClauses.add(clause);
        if (node == null) {
            this.selectNames.add(alias);
        } else {
            this.selectNames.add(alias + "." + node);
        }
    }

    void addObjectRefSelectConstraint(String alias, String nodeName) {
        if (alias == null) {
            alias = this.varStack.peek();
        }
        String prefix = nodeName != null ? alias + "." + nodeName : alias;
        String archetypeId = prefix + ".archetypeId";
        String id = prefix + ".id";
        String linkId = prefix + ".linkId";
        this.selectClauses.add(archetypeId);
        this.selectClauses.add(id);
        this.selectClauses.add(linkId);
        this.selectNames.add(archetypeId);
        this.selectNames.add(id);
        this.selectNames.add(linkId);
        this.refSelectNames.add(prefix);
    }

    QueryContext addConstraint(String alias, String property, RelationalOp op, Object value) {
        if (alias == null) {
            alias = this.varStack.peek();
        }
        this.addConstraint(alias + "." + property, op, value);
        return this;
    }

    QueryContext addConstraint(String property, RelationalOp op, Object value) {
        Clause clause = this.getClause();
        clause.appendOperator();
        clause.append(property).append(" ").append(this.getOperator(op, value));
        if (value != null) {
            String varName = this.paramNames.getName(property);
            clause.append(" :").append(varName);
            this.params.put(varName, this.getValue(op, value));
        }
        return this;
    }

    QueryContext addSortConstraint(String alias, String property, boolean ascending) {
        if (this.orderedClause.length() > this.initOrderedClauseLen) {
            this.orderedClause.append(", ");
        }
        if (alias == null) {
            alias = this.varStack.peek();
        }
        this.orderedClause.append(alias).append(".").append(property);
        if (ascending) {
            this.orderedClause.append(" asc");
        } else {
            this.orderedClause.append(" desc");
        }
        return this;
    }

    QueryContext addNodeConstraint(String property, NodeConstraint constraint) {
        Clause clause = this.getClause();
        RelationalOp op = constraint.getOperator();
        String qname = this.getQualifiedPropertyName(property);
        Object[] parameters = constraint.getParameters();
        switch (op) {
            case BTW: {
                String varName;
                if (parameters[0] == null && parameters[1] == null) break;
                clause.push(LogicalOperator.AND);
                if (parameters[0] != null) {
                    clause.appendOperator();
                    varName = this.paramNames.getName(property);
                    clause.append(qname).append(this.getOperator(RelationalOp.GTE, parameters[0])).append(" :").append(varName);
                    this.params.put(varName, this.getValue(RelationalOp.GTE, parameters[0]));
                }
                if (parameters[1] != null) {
                    clause.appendOperator();
                    varName = this.paramNames.getName(property);
                    clause.append(qname).append(this.getOperator(RelationalOp.LTE, parameters[1])).append(" :").append(varName);
                    this.params.put(varName, this.getValue(RelationalOp.LTE, parameters[1]));
                }
                clause.pop();
                break;
            }
            case EQ: 
            case GT: 
            case GTE: 
            case LT: 
            case LTE: 
            case NE: {
                clause.appendOperator();
                String varName = this.paramNames.getName(property);
                clause.append(qname).append(" ").append(this.getOperator(op, parameters[0])).append(" :").append(varName);
                this.params.put(varName, this.getValue(op, parameters[0]));
                break;
            }
            case IS_NULL: 
            case NOT_NULL: {
                clause.appendOperator();
                String opNull = " " + this.getOperator(op, null);
                if (this.isReference(property)) {
                    clause.append(qname).append(".id").append(opNull);
                    break;
                }
                clause.append(qname).append(opNull);
                break;
            }
            case IN: {
                clause.appendOperator();
                boolean ref = this.isReference(property);
                clause.append(qname);
                if (ref) {
                    clause.append(".id");
                }
                clause.append(" ").append(this.getOperator(op, null)).append(" (");
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object parameter : parameters) {
                    values.add(this.getValue(op, parameter));
                }
                String varName = this.paramNames.getName(property);
                clause.append(":").append(varName);
                this.params.put(varName, values);
                clause.append(")");
                break;
            }
            default: {
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.OperatorNotSupported, new Object[]{op});
            }
        }
        return this;
    }

    QueryContext addPropertyConstraint(String lhs, RelationalOp operator, String rhs) {
        Clause clause = this.getClause();
        switch (operator) {
            case EQ: 
            case GT: 
            case GTE: 
            case LT: 
            case LTE: 
            case NE: {
                clause.appendOperator();
                clause.append(lhs).append(" ").append(this.getOperator(operator, rhs)).append(" ").append(rhs);
                break;
            }
            default: {
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.OperatorNotSupported, new Object[]{operator});
            }
        }
        return this;
    }

    QueryContext addNotConstraint() {
        this.whereClause.appendNot();
        return this;
    }

    QueryContext addExistsConstraint(String query) {
        this.whereClause.appendOperator();
        this.whereClause.append("exists (");
        this.whereClause.append(query);
        this.whereClause.append(")");
        return this;
    }

    private String getOperator(RelationalOp operator, Object param) {
        switch (operator) {
            case EQ: {
                String sparam;
                if (param instanceof String && ((sparam = (String)param).contains("%") || sparam.contains("*"))) {
                    return "like";
                }
                return "=";
            }
            case GT: {
                return ">";
            }
            case GTE: {
                return ">=";
            }
            case LT: {
                return "<";
            }
            case LTE: {
                return "<=";
            }
            case NE: {
                return "!=";
            }
            case IS_NULL: {
                return "is NULL";
            }
            case NOT_NULL: {
                return "is NOT NULL";
            }
            case IN: {
                return "in";
            }
        }
        throw new QueryBuilderException(QueryBuilderException.ErrorCode.OperatorNotSupported, new Object[]{operator});
    }

    private Object getValue(RelationalOp operator, Object param) {
        if (operator == RelationalOp.EQ) {
            if (param instanceof String) {
                return ((String)param).replace("*", "%");
            }
            return param;
        }
        if (param instanceof Reference) {
            return ((Reference)param).getId();
        }
        return param;
    }

    private String getQualifiedPropertyName(String property) {
        int index = property.indexOf(46);
        if (index == -1) {
            return this.varStack.peek() + "." + property;
        }
        String prefix = property.substring(0, index);
        if (this.typesets.get(prefix) == null) {
            return this.varStack.peek() + "." + property;
        }
        return property;
    }

    private boolean addTypeSet(TypeSet types, String alias) {
        if (types.getAlias() != null) {
            this.typeNames.reserve(types.getAlias());
            alias = types.getAlias();
        } else {
            if (alias == null) {
                alias = types.getClassName();
            }
            alias = this.typeNames.getName(alias);
            types.setAlias(alias);
        }
        TypeSet existing = this.typesets.get(alias);
        if (existing != null) {
            if (!existing.contains(types)) {
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.DuplicateAlias, alias);
            }
            return false;
        }
        this.typesets.put(types.getAlias(), types);
        return true;
    }

    private boolean isReference(String property) {
        String node;
        String alias;
        int index = property.indexOf(46);
        if (index == -1) {
            alias = this.varStack.peek();
            node = property;
        } else {
            alias = property.substring(0, index);
            node = property.substring(index + 1);
        }
        TypeSet set = this.getTypeSet(alias);
        if (set == null) {
            return false;
        }
        for (ArchetypeDescriptor archetype : set.getDescriptors()) {
            NodeDescriptor descriptor = archetype.getNodeDescriptor(node);
            if (descriptor != null && descriptor.isObjectReference()) continue;
            return false;
        }
        return true;
    }

    private Clause getClause() {
        return this.isOuterJoin() ? this.getFromClause() : this.whereClause;
    }

    private FromClause getFromClause() {
        return this.fromStack.peek();
    }

    static enum LogicalOperator {
        AND(" and "),
        OR(" or ");

        private final String value;

        private LogicalOperator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class NameAllocator {
        private final Set<String> names = new HashSet<String>();

        private NameAllocator() {
        }

        public void reserve(String name) {
            this.names.add(name);
        }

        public String getName(String name) {
            int index = name.lastIndexOf(".");
            if (index != -1) {
                name = name.substring(index + 1);
            }
            if (name.endsWith("DO")) {
                name = name.substring(0, name.length() - 2);
            }
            name = WordUtils.uncapitalize((String)name);
            int i = 0;
            String result = name + i;
            while (this.names.contains(result)) {
                result = name + ++i;
            }
            this.names.add(result);
            return result;
        }
    }

    private static class Counter<T> {
        T operator;
        int count;

        Counter(T operator) {
            this.operator = operator;
        }
    }

    private static class FromClause
    extends Clause {
        private final boolean needsComma;
        private boolean with;

        public FromClause(String type, String alias) {
            this(null, type, alias);
        }

        public FromClause(JoinConstraint.JoinType join, String type, String alias) {
            this(join, null, type, alias);
        }

        public FromClause(JoinConstraint.JoinType join, String variable, String property, String alias) {
            if (join == JoinConstraint.JoinType.InnerJoin && variable == null) {
                this.needsComma = true;
            } else {
                this.needsComma = false;
                this.appendJoin(join);
            }
            if (variable != null) {
                super.append(variable);
                super.append(".");
            }
            super.append(property);
            super.append(" as ");
            super.append(alias);
            this.with = false;
        }

        public boolean needsComma() {
            return this.needsComma;
        }

        @Override
        public Clause append(String value) {
            if (!this.with) {
                super.append(" with ");
                this.with = true;
            }
            super.append(value);
            return this;
        }

        private void appendJoin(JoinConstraint.JoinType join) {
            if (join == JoinConstraint.JoinType.InnerJoin) {
                super.append("inner join ");
            } else if (join == JoinConstraint.JoinType.LeftOuterJoin) {
                super.append("left outer join ");
            } else if (join == JoinConstraint.JoinType.RightOuterJoin) {
                super.append("right outer join ");
            }
        }
    }

    private static class Clause {
        StringBuilder buffer = new StringBuilder();
        Deque<Counter<LogicalOperator>> stack = new ArrayDeque<Counter<LogicalOperator>>();
        private boolean not;

        private Clause() {
        }

        public Counter<LogicalOperator> push(LogicalOperator operator) {
            this.appendOperator();
            Counter<LogicalOperator> result = new Counter<LogicalOperator>(operator);
            this.stack.push(result);
            this.append("(");
            return result;
        }

        public void pop() {
            this.stack.pop();
            this.append(")");
            this.not = false;
        }

        public void appendOperator() {
            if (!this.not && !this.stack.isEmpty()) {
                if (this.stack.peek().count > 0) {
                    String op = ((LogicalOperator)((Object)this.stack.peek().operator)).getValue();
                    this.buffer.append(op);
                }
                ++this.stack.peek().count;
            }
        }

        public void appendNot() {
            this.appendOperator();
            this.buffer.append(QueryContext.NOT_CONSTRAINT);
            this.not = true;
        }

        public boolean isEmpty() {
            return this.buffer.length() == 0;
        }

        public String toString() {
            return this.buffer.toString();
        }

        public Clause append(String value) {
            this.not = false;
            this.buffer.append(value);
            return this;
        }
    }
}

