/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.jdbc.BlobProxy;
import org.hibernate.query.Query;
import org.openvpms.component.business.dao.hibernate.cache.ArchetypeIdCache;
import org.openvpms.component.business.dao.hibernate.im.common.CompoundAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.entity.IMObjectResultCollector;
import org.openvpms.component.business.dao.hibernate.im.plugin.PluginAssembler;
import org.openvpms.component.business.dao.hibernate.im.plugin.PluginDOImpl;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.plugin.Plugin;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.springframework.transaction.annotation.Transactional;

public class PluginDAOHibernate
implements PluginDAO {
    private final SessionFactory factory;
    private final ArchetypeIdCache archetypeIds;
    private final CompoundAssembler assembler;
    private static final String QUERY_BY_KEY = "from " + PluginDOImpl.class.getName() + " as plugin where plugin.key = :key";
    private static final String QUERY_ACTIVE = "from " + PluginDOImpl.class.getName() + " as plugin where plugin.active = 1";

    public PluginDAOHibernate(SessionFactory factory, IArchetypeDescriptorCache archetypes, ArchetypeIdCache archetypeIds) {
        this.factory = factory;
        this.archetypeIds = archetypeIds;
        this.assembler = new Assembler(archetypes);
    }

    @Override
    @Transactional(readOnly=true)
    public Plugin getPlugin(String key) {
        Plugin result = null;
        Session session = this.factory.getCurrentSession();
        PluginDOImpl plugin = this.get(key, session);
        if (plugin != null) {
            Context context = Context.getContext(session, this.assembler, this.archetypeIds);
            IMObjectResultCollector collector = new IMObjectResultCollector();
            collector.setContext(context);
            result = (Plugin)this.assembler.assemble(plugin, context);
            context.resolveDeferredReferences();
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public Iterator<Plugin> getPlugins() {
        Session session = this.factory.getCurrentSession();
        Query query = session.createQuery(QUERY_ACTIVE, PluginDOImpl.class);
        Context context = Context.getContext(session, this.assembler, this.archetypeIds);
        IMObjectResultCollector collector = new IMObjectResultCollector();
        collector.setContext(context);
        for (PluginDOImpl object : query.list()) {
            collector.collect(object);
        }
        context.resolveDeferredReferences();
        List results = collector.getPage().getResults();
        return results.iterator();
    }

    @Override
    @Transactional(readOnly=true)
    public InputStream getBinary(String key) {
        Blob data;
        InputStream result = null;
        PluginDOImpl plugin = this.get(key, this.factory.getCurrentSession());
        Blob blob = data = plugin != null ? plugin.getData() : null;
        if (data != null) {
            try {
                result = data.getBinaryStream();
            }
            catch (SQLException exception) {
                throw new RuntimeException("Failed to get plugin data for key=" + key + ": " + exception.getMessage(), exception);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void save(String key, String name, InputStream stream) {
        Session session = this.factory.getCurrentSession();
        PluginDOImpl plugin = this.get(key, session);
        if (plugin == null) {
            plugin = new PluginDOImpl();
            plugin.setKey(key);
            plugin.setArchetypeId(new ArchetypeId("plugin.default", "1.0"));
            plugin.setActive(true);
        }
        plugin.setName(name);
        try {
            byte[] data = IOUtils.toByteArray((InputStream)stream);
            plugin.setData(BlobProxy.generateProxy((byte[])data));
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to read " + name + ": " + exception.getMessage(), exception);
        }
        session.saveOrUpdate((Object)plugin);
        session.flush();
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = false;
        Session session = this.factory.getCurrentSession();
        PluginDOImpl plugin = this.get(key, session);
        if (plugin != null) {
            session.remove((Object)plugin);
            result = true;
        }
        return result;
    }

    private PluginDOImpl get(String key, Session session) {
        Query query = session.createQuery(QUERY_BY_KEY, PluginDOImpl.class);
        query.setParameter("key", (Object)key);
        return this.get((Query<PluginDOImpl>)query);
    }

    private PluginDOImpl get(Query<PluginDOImpl> query) {
        List plugins = query.list();
        return !plugins.isEmpty() ? (PluginDOImpl)plugins.get(0) : null;
    }

    private static class Assembler
    extends CompoundAssembler {
        Assembler(IArchetypeDescriptorCache archetypes) {
            super(archetypes);
            this.addAssembler(new PluginAssembler());
        }
    }
}

