/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.lookup;

import org.hibernate.Session;
import org.openvpms.component.business.dao.hibernate.im.common.AbstractDeleteHandler;
import org.openvpms.component.business.dao.hibernate.im.common.CompoundAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupDO;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupRelationshipDO;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupReplacer;
import org.openvpms.component.business.dao.im.common.IMObjectDAOException;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;

public class LookupDeleteHandler
extends AbstractDeleteHandler {
    private IArchetypeDescriptorCache archetypes;

    public LookupDeleteHandler(CompoundAssembler assembler, IArchetypeDescriptorCache archetypes) {
        super(assembler);
        this.archetypes = archetypes;
    }

    @Override
    public void delete(IMObject object, Session session, Context context) {
        if (this.isInUse((Lookup)object, session)) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.CannotDeleteLookupInUse, object.getObjectReference());
        }
        super.delete(object, session, context);
    }

    @Override
    protected void delete(IMObjectDO object, Session session, Context context) {
        LookupRelationshipDO[] relationships;
        LookupDO lookup = (LookupDO)object;
        for (LookupRelationshipDO relationhip : relationships = lookup.getSourceLookupRelationships().toArray(new LookupRelationshipDO[lookup.getSourceLookupRelationships().size()])) {
            lookup.removeSourceLookupRelationship(relationhip);
            LookupDO target = (LookupDO)relationhip.getTarget();
            if (target == null) continue;
            target.removeTargetLookupRelationship(relationhip);
        }
        for (LookupRelationshipDO relationship : relationships = lookup.getTargetLookupRelationships().toArray(new LookupRelationshipDO[lookup.getTargetLookupRelationships().size()])) {
            lookup.removeTargetLookupRelationship(relationship);
            LookupDO source = (LookupDO)relationship.getSource();
            if (source == null) continue;
            source.removeSourceLookupRelationship(relationship);
        }
        context.remove(lookup);
    }

    private boolean isInUse(Lookup lookup, Session session) {
        LookupReplacer replacer = new LookupReplacer(this.archetypes);
        return replacer.isUsed(lookup, session);
    }
}

