/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.lookup;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectDOImpl;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupDO;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupLinkDO;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupRelationshipDO;
import org.openvpms.component.business.domain.archetype.ArchetypeId;

public class LookupDOImpl
extends AuditableIMObjectDOImpl
implements LookupDO {
    private String code;
    private boolean defaultLookup;
    private Set<LookupRelationshipDO> sourceLookupRelationshipDOs = new HashSet<LookupRelationshipDO>();
    private Set<LookupRelationshipDO> targetLookupRelationshipDOs = new HashSet<LookupRelationshipDO>();
    private Set<LookupLinkDO> links = new HashSet<LookupLinkDO>();

    public LookupDOImpl() {
    }

    public LookupDOImpl(ArchetypeId archetypeId, String code) {
        this.setArchetypeId(archetypeId);
        this.setCode(code);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public boolean isDefaultLookup() {
        return this.defaultLookup;
    }

    @Override
    public void setDefaultLookup(boolean defaultLookup) {
        this.defaultLookup = defaultLookup;
    }

    @Override
    public Set<LookupRelationshipDO> getSourceLookupRelationships() {
        return this.sourceLookupRelationshipDOs;
    }

    @Override
    public void addSourceLookupRelationship(LookupRelationshipDO source) {
        this.sourceLookupRelationshipDOs.add(source);
        source.setSource(this);
    }

    @Override
    public void removeSourceLookupRelationship(LookupRelationshipDO source) {
        this.sourceLookupRelationshipDOs.remove(source);
    }

    @Override
    public Set<LookupRelationshipDO> getTargetLookupRelationships() {
        return this.targetLookupRelationshipDOs;
    }

    @Override
    public void addTargetLookupRelationship(LookupRelationshipDO target) {
        this.targetLookupRelationshipDOs.add(target);
    }

    @Override
    public void removeTargetLookupRelationship(LookupRelationshipDO target) {
        this.targetLookupRelationshipDOs.remove(target);
    }

    @Override
    public Set<LookupLinkDO> getLookupLinks() {
        return this.links;
    }

    @Override
    public void addLookupLink(LookupLinkDO link) {
        link.setSource(this);
        this.links.add(link);
    }

    @Override
    public void removeLookupLink(LookupLinkDO link) {
        this.links.remove(link);
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj == this) {
            equal = true;
        } else if (obj instanceof LookupDO) {
            LookupDO rhs = (LookupDO)obj;
            equal = Objects.equals(this.code, rhs.getCode()) && Objects.equals(this.getArchetypeId(), rhs.getArchetypeId());
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getArchetypeId()).append((Object)this.getCode()).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("uid", this.getId()).append("code", (Object)this.getCode()).append("default", this.isDefaultLookup()).toString();
    }

    protected void setSourceLookupRelationships(Set<LookupRelationshipDO> relationships) {
        this.sourceLookupRelationshipDOs = relationships;
    }

    protected void setTargetLookupRelationships(Set<LookupRelationshipDO> relationships) {
        this.targetLookupRelationshipDOs = relationships;
    }

    protected void setLookupLinks(Set<LookupLinkDO> links) {
        this.links = links;
    }
}

