/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.lookup;

import java.util.Objects;
import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.SetAssembler;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupDO;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupDOImpl;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupLinkDO;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupRelationshipDO;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.domain.im.lookup.LookupLink;
import org.openvpms.component.business.domain.im.lookup.LookupRelationship;

public class LookupAssembler
extends AuditableIMObjectAssembler<Lookup, LookupDO> {
    private static final SetAssembler<LookupRelationship, LookupRelationshipDO> RELATIONSHIPS = SetAssembler.create(LookupRelationship.class, LookupRelationshipDO.class);
    private static final SetAssembler<LookupLink, LookupLinkDO> LINKS = SetAssembler.create(LookupLink.class, LookupLinkDO.class);

    public LookupAssembler() {
        super(org.openvpms.component.model.lookup.Lookup.class, Lookup.class, LookupDO.class, LookupDOImpl.class);
    }

    @Override
    protected void assembleDO(LookupDO target, Lookup source, DOState state, Context context) {
        super.assembleDO(target, source, state, context);
        if (!Objects.equals(target.getCode(), source.getCode())) {
            target.setCode(source.getCode());
        }
        if (target.isDefaultLookup() != source.isDefaultLookup()) {
            target.setDefaultLookup(source.isDefaultLookup());
        }
        RELATIONSHIPS.assembleDO(target.getSourceLookupRelationships(), source.getSourceLookupRelationships(), state, context);
        RELATIONSHIPS.assembleDO(target.getTargetLookupRelationships(), source.getTargetLookupRelationships(), state, context);
        LINKS.assembleDO(target.getLookupLinks(), source.getLookupLinks(), state, context);
    }

    @Override
    protected void assembleObject(Lookup target, LookupDO source, Context context) {
        super.assembleObject(target, source, context);
        target.setCode(source.getCode());
        target.setDefaultLookup(source.isDefaultLookup());
        RELATIONSHIPS.assembleObject(target.getSourceLookupRelationships(), source.getSourceLookupRelationships(), context);
        RELATIONSHIPS.assembleObject(target.getTargetLookupRelationships(), source.getTargetLookupRelationships(), context);
        LINKS.assembleObject(target.getLookupLinks(), source.getLookupLinks(), context);
    }

    @Override
    protected Lookup create(LookupDO object) {
        return new Lookup();
    }

    @Override
    protected LookupDO create(Lookup object) {
        return new LookupDOImpl();
    }
}

