/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.entity;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.openvpms.component.business.dao.hibernate.im.entity.ObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectingObjectLoader
implements ObjectLoader {
    private final Map<Class<?>, Method[]> collectionMethods = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(ReflectingObjectLoader.class);

    @Override
    public void load(Object object) {
        this.load(object, new HashSet<Object>());
    }

    protected void load(Object object, Set<Object> loaded) {
        Method[] methods;
        Hibernate.initialize((Object)object);
        loaded.add(object);
        for (Method method : methods = this.getCollectionMethods(object)) {
            Collection collection = null;
            try {
                collection = (Collection)method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                log.warn(exception.getMessage(), (Throwable)exception);
            }
            if (collection == null) continue;
            for (Object elt : collection) {
                if (loaded.contains(elt)) continue;
                this.load(elt, loaded);
            }
        }
    }

    private synchronized Method[] getCollectionMethods(Object object) {
        Class<?> clazz = object.getClass();
        Method[] result = this.collectionMethods.get(clazz);
        if (result == null) {
            Method[] methods;
            ArrayList<Method> list = new ArrayList<Method>();
            for (Method method : methods = clazz.getMethods()) {
                if (!this.isCollectionGetter(method)) continue;
                list.add(method);
            }
            result = list.toArray(new Method[0]);
            this.collectionMethods.put(clazz, result);
        }
        return result;
    }

    private boolean isCollectionGetter(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        return Modifier.isPublic(method.getModifiers()) && paramTypes.length == 0 && Collection.class.isAssignableFrom(returnType) && method.getName().startsWith("get");
    }
}

