/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.business.dao.hibernate.cache.ArchetypeIdCache;
import org.openvpms.component.business.dao.hibernate.im.common.Assembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.entity.HibernateResultCollector;
import org.openvpms.component.business.dao.hibernate.im.entity.ObjectLoader;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.system.common.query.ObjectSet;

public class ObjectSetResultCollector
extends HibernateResultCollector<ObjectSet> {
    private final String[] refColumnNames;
    private final List<ObjectSet> result = new ArrayList<ObjectSet>();
    private final Map<String, Set<String>> types;
    private final ArchetypeIdCache archetypeIds;
    private String[] names;

    public ObjectSetResultCollector(List<String> names, List<String> refNames, Map<String, Set<String>> types, ArchetypeIdCache archetypeIds) {
        if (names != null) {
            this.names = names.toArray(new String[0]);
            this.refColumnNames = new String[this.names.length];
            for (String refName : refNames) {
                int index = names.indexOf(refName + ".archetypeId");
                if (index == -1 || index + 2 >= this.refColumnNames.length) {
                    throw new IllegalArgumentException("Argument 'refNames' contains an invalid reference");
                }
                this.refColumnNames[index] = refName + ".reference";
            }
        } else {
            this.refColumnNames = null;
        }
        this.types = types;
        this.archetypeIds = archetypeIds;
    }

    @Override
    public void collect(Object object) {
        ObjectSet set = this.createObjectSet();
        ObjectLoader loader = this.getLoader();
        if (this.names == null) {
            this.getNames(object);
        }
        if (object instanceof Object[]) {
            this.collect((Object[])object, set, loader);
        } else {
            if (this.names.length != 1) {
                throw new IllegalStateException("Mismatch args");
            }
            if (object instanceof IMObjectDO) {
                object = this.assemble((IMObjectDO)object);
            } else {
                loader.load(object);
            }
            set.set(this.names[0], object);
        }
        this.result.add(set);
    }

    @Override
    protected List<ObjectSet> getResults() {
        return this.result;
    }

    private void collect(Object[] values, ObjectSet set, ObjectLoader loader) {
        if (values.length != this.names.length) {
            throw new IllegalStateException("Mismatch args");
        }
        int i = 0;
        while (i < this.names.length) {
            if (this.refColumnNames != null && this.refColumnNames[i] != null) {
                IMObjectReference ref = null;
                ArchetypeId archetypeId = (ArchetypeId)values[i];
                if (archetypeId != null) {
                    archetypeId = this.archetypeIds.get(archetypeId);
                    Long id = (Long)values[i + 1];
                    if (id == null) {
                        id = -1L;
                    }
                    String linkId = (String)values[i + 2];
                    ref = new IMObjectReference(archetypeId, (long)id, linkId);
                }
                set.set(this.refColumnNames[i], ref);
                i += 3;
                continue;
            }
            Object value = values[i];
            if (value instanceof IMObjectDO) {
                value = this.assemble((IMObjectDO)value);
            } else if (value instanceof ArchetypeId) {
                value = this.archetypeIds.get((ArchetypeId)value);
            } else if (value != null) {
                loader.load(value);
            }
            set.set(this.names[i], value);
            ++i;
        }
    }

    private IMObject assemble(IMObjectDO object) {
        Context context = this.getContext();
        Assembler assembler = context.getAssembler();
        return assembler.assemble(object, context);
    }

    private ObjectSet createObjectSet() {
        ObjectSet set = new ObjectSet();
        if (this.types != null) {
            for (Map.Entry<String, Set<String>> entry : this.types.entrySet()) {
                set.addType(entry.getKey(), entry.getValue());
            }
        }
        return set;
    }

    private void getNames(Object object) {
        if (object instanceof Object[]) {
            Object[] values = (Object[])object;
            this.names = new String[values.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = "" + i;
            }
        } else {
            this.names = new String[1];
            this.names[0] = "0";
        }
    }
}

