/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.entity;

import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.dao.hibernate.im.common.SetAssembler;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityDO;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityIdentityDO;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityLinkDO;
import org.openvpms.component.business.dao.hibernate.im.entity.EntityRelationshipDO;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupDO;
import org.openvpms.component.business.domain.im.common.Entity;
import org.openvpms.component.business.domain.im.common.EntityIdentity;
import org.openvpms.component.business.domain.im.common.EntityLink;
import org.openvpms.component.business.domain.im.common.EntityRelationship;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;

public abstract class EntityAssembler<T extends Entity, DO extends EntityDO>
extends AuditableIMObjectAssembler<T, DO> {
    private static final SetAssembler<EntityIdentity, EntityIdentityDO> IDENT = SetAssembler.create(EntityIdentity.class, EntityIdentityDO.class);
    private static final SetAssembler<Lookup, LookupDO> LOOKUPS = SetAssembler.create(Lookup.class, LookupDO.class, true);
    private static final SetAssembler<EntityRelationship, EntityRelationshipDO> RELATIONSHIP = SetAssembler.create(EntityRelationship.class, EntityRelationshipDO.class);
    private static final SetAssembler<EntityLink, EntityLinkDO> LINKS = SetAssembler.create(EntityLink.class, EntityLinkDO.class);

    protected EntityAssembler(Class<? extends IMObject> type, Class<T> typeImpl, Class<DO> typeDO, Class<? extends IMObjectDOImpl> implDO) {
        super(type, typeImpl, typeDO, implDO);
    }

    @Override
    protected void assembleDO(DO target, T source, DOState state, Context context) {
        super.assembleDO(target, source, state, context);
        IDENT.assembleDO(target.getIdentities(), ((Entity)source).getIdentities(), state, context);
        LOOKUPS.assembleDO(target.getClassifications(), ((Entity)source).getClassifications(), state, context);
        RELATIONSHIP.assembleDO(target.getSourceEntityRelationships(), ((Entity)source).getSourceEntityRelationships(), state, context);
        RELATIONSHIP.assembleDO(target.getTargetEntityRelationships(), ((Entity)source).getTargetEntityRelationships(), state, context);
        LINKS.assembleDO(target.getEntityLinks(), ((Entity)source).getEntityLinks(), state, context);
    }

    @Override
    protected void assembleObject(T target, DO source, Context context) {
        super.assembleObject(target, source, context);
        IDENT.assembleObject(((Entity)target).getIdentities(), source.getIdentities(), context);
        LOOKUPS.assembleObject(((Entity)target).getClassifications(), source.getClassifications(), context);
        RELATIONSHIP.assembleObject(((Entity)target).getSourceEntityRelationships(), source.getSourceEntityRelationships(), context);
        RELATIONSHIP.assembleObject(((Entity)target).getTargetEntityRelationships(), source.getTargetEntityRelationships(), context);
        LINKS.assembleObject(((Entity)target).getEntityLinks(), source.getEntityLinks(), context);
    }
}

