/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.business.dao.hibernate.im.common.AbstractAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Assembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;

public class SetAssembler<T extends IMObject, DO extends IMObjectDO>
extends AbstractAssembler {
    private final Class<T> type;
    private final Class<? extends DO> typeDO;
    private final boolean referenced;

    public SetAssembler(Class<T> type, Class<? extends DO> typeDO, boolean referenced) {
        this.type = type;
        this.typeDO = typeDO;
        this.referenced = referenced;
    }

    public void assembleDO(Set<DO> target, Set<T> source, DOState state, Context context) {
        if (target.isEmpty()) {
            for (IMObject src : source) {
                DOState result = this.getDO(src, context);
                target.add(this.typeDO.cast(result.getObject()));
                state.addState(result);
            }
        } else if (source.isEmpty()) {
            target.clear();
        } else {
            Assembler assembler = context.getAssembler();
            Map<IMObjectReference, DO> targetMap = this.getDO(target);
            Map<IMObjectReference, T> sourceMap = this.get(source);
            Map<IMObjectReference, DO> retained = this.getRetained(targetMap, sourceMap);
            for (IMObjectDO iMObjectDO : this.getRemoved(targetMap, retained)) {
                target.remove(iMObjectDO);
                state.removeState(iMObjectDO);
                if (this.referenced) continue;
                context.remove(iMObjectDO);
            }
            for (Map.Entry entry : retained.entrySet()) {
                IMObjectDO current = (IMObjectDO)entry.getValue();
                IMObject src = (IMObject)sourceMap.get(entry.getKey());
                DOState result = assembler.assemble(current, src, context);
                state.addState(result);
            }
            for (IMObject iMObject : this.getAdded(retained, sourceMap)) {
                DOState result = this.getDO(iMObject, context);
                target.add(this.typeDO.cast(result.getObject()));
                state.addState(result);
            }
        }
    }

    public void assembleObject(Set<T> target, Set<DO> source, Context context) {
        if (!target.isEmpty()) {
            target.clear();
        }
        if (!source.isEmpty()) {
            for (IMObjectDO src : source) {
                T result = this.getObject(src, this.type, context);
                target.add(result);
            }
        }
    }

    public static <T extends IMObject, DO extends IMObjectDO> SetAssembler<T, DO> create(Class<T> type, Class<DO> typeDO) {
        return SetAssembler.create(type, typeDO, false);
    }

    public static <T extends IMObject, DO extends IMObjectDO> SetAssembler<T, DO> create(Class<T> type, Class<DO> typeDO, boolean referenced) {
        return new SetAssembler<T, DO>(type, typeDO, referenced);
    }

    private Map<IMObjectReference, T> get(Set<T> set) {
        HashMap<IMObjectReference, IMObject> result = new HashMap<IMObjectReference, IMObject>();
        for (IMObject object : set) {
            result.put(object.getObjectReference(), object);
        }
        return result;
    }

    private Map<IMObjectReference, DO> getDO(Set<DO> set) {
        HashMap<IMObjectReference, IMObjectDO> result = new HashMap<IMObjectReference, IMObjectDO>();
        for (IMObjectDO object : set) {
            result.put(object.getObjectReference(), object);
        }
        return result;
    }

    private Collection<DO> getRemoved(Map<IMObjectReference, DO> target, Map<IMObjectReference, DO> retained) {
        HashMap<IMObjectReference, DO> result = new HashMap<IMObjectReference, DO>(target);
        result.keySet().removeAll(retained.keySet());
        return result.values();
    }

    private Map<IMObjectReference, DO> getRetained(Map<IMObjectReference, DO> target, Map<IMObjectReference, T> source) {
        HashMap<IMObjectReference, DO> result = new HashMap<IMObjectReference, DO>(target);
        result.keySet().retainAll(source.keySet());
        return result;
    }

    private Collection<T> getAdded(Map<IMObjectReference, DO> retained, Map<IMObjectReference, T> source) {
        HashMap<IMObjectReference, T> result = new HashMap<IMObjectReference, T>(source);
        result.keySet().removeAll(retained.keySet());
        return result.values();
    }
}

