/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import java.util.Map;
import java.util.Set;
import org.openvpms.component.business.dao.hibernate.im.common.AbstractAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Assembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.MapConverter;
import org.openvpms.component.business.domain.im.common.IMObject;

public class MapAssembler<K, T extends IMObject, DO extends IMObjectDO>
extends AbstractAssembler {
    private final Class<T> type;

    public MapAssembler(Class<T> type) {
        this.type = type;
    }

    public void assembleDO(Map<K, DO> target, Map<K, T> source, DOState state, Context context) {
        DOMapConverter converter = new DOMapConverter(state, context);
        converter.convert(target, source);
    }

    public void assembleObject(Map<K, T> target, Map<K, DO> source, Context context) {
        if (!target.isEmpty()) {
            target.clear();
        }
        if (!source.isEmpty()) {
            for (Map.Entry<K, DO> entry : source.entrySet()) {
                T result = this.getObject((IMObjectDO)entry.getValue(), this.type, context);
                target.put(entry.getKey(), result);
            }
        }
    }

    public static <K, T extends IMObject, DO extends IMObjectDO> MapAssembler<K, T, DO> create(Class<T> type) {
        return new MapAssembler<K, T, DO>(type);
    }

    private class DOMapConverter
    extends MapConverter<K, T, DO> {
        private final DOState state;
        private final Context context;

        public DOMapConverter(DOState state, Context context) {
            this.state = state;
            this.context = context;
        }

        @Override
        protected void convert(Map<K, DO> map, K key, DO target, T source) {
            Assembler assembler = this.context.getAssembler();
            DOState child = assembler.assemble((IMObjectDO)target, (IMObject)source, this.context);
            this.state.addState(child);
        }

        @Override
        protected DO convert(T value) {
            DOState child = MapAssembler.this.getDO(value, this.context);
            this.state.addState(child);
            return child.getObject();
        }

        @Override
        protected void remove(Map<K, DO> target, Set<K> set) {
            for (Object key : set) {
                IMObjectDO object = (IMObjectDO)target.get(key);
                this.state.removeState(object);
                this.context.remove(object);
            }
            super.remove(target, set);
        }
    }
}

