/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.builder.StandardToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.datatypes.basic.TypedValue;
import org.openvpms.component.business.domain.im.datatypes.basic.TypedValueMap;

public class IMObjectDOImpl
implements IMObjectDO {
    protected static final StandardToStringStyle STYLE = new StandardToStringStyle();
    private ArchetypeId archetypeId;
    private long id = -1L;
    private String linkId;
    private IMObjectReference reference;
    private long version;
    private String name;
    private String description;
    private boolean active = true;
    private Map<String, TypedValue> details = new HashMap<String, TypedValue>();

    public IMObjectDOImpl() {
    }

    public IMObjectDOImpl(ArchetypeId archetypeId) {
        this.setArchetypeId(archetypeId);
    }

    @Override
    public ArchetypeId getArchetypeId() {
        return this.archetypeId;
    }

    @Override
    public void setArchetypeId(ArchetypeId archetypeId) {
        this.archetypeId = archetypeId;
        this.reference = null;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
        this.reference = null;
    }

    @Override
    public String getLinkId() {
        if (this.linkId == null && this.id == -1L) {
            this.linkId = UUID.randomUUID().toString();
        }
        return this.linkId;
    }

    @Override
    public void setLinkId(String linkId) {
        this.linkId = linkId;
        this.reference = null;
    }

    @Override
    public IMObjectReference getObjectReference() {
        if (this.reference == null) {
            this.reference = new IMObjectReference(this.getArchetypeId(), this.getId(), this.getLinkId());
        }
        return this.reference;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isNew() {
        return this.id == -1L;
    }

    @Override
    public Map<String, Object> getDetails() {
        return new TypedValueMap(this.details);
    }

    @Override
    public void setDetails(Map<String, Object> details) {
        this.details = TypedValueMap.create(details);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IMObjectDO)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IMObjectDO rhs = (IMObjectDO)obj;
        return this.getObjectReference().equals(rhs.getObjectReference());
    }

    public int hashCode() {
        return this.getLinkId().hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)STYLE).append("id", this.id).append("linkId", (Object)this.linkId).append("archetypeId", (Object)this.archetypeId).append("version", this.version).toString();
    }

    static {
        STYLE.setUseShortClassName(true);
        STYLE.setUseIdentityHashCode(false);
    }
}

