/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;
import org.hibernate.Hibernate;
import org.openvpms.component.business.dao.hibernate.im.common.AbstractAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Assembler;
import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.DeferredReference;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.dao.hibernate.im.common.MapConverter;
import org.openvpms.component.business.dao.hibernate.im.security.UserDO;
import org.openvpms.component.business.dao.hibernate.im.security.UserDOImpl;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.Reference;

public abstract class IMObjectAssembler<T extends IMObject, DO extends IMObjectDO>
extends AbstractAssembler
implements Assembler {
    private final Class<? extends org.openvpms.component.model.object.IMObject> type;
    private final Class<T> typeImpl;
    private final Class<DO> typeDO;
    private final Class<? extends IMObjectDOImpl> implDO;
    private static final MapConverter<String, Object, Object> DETAILS = new MapConverter<String, Object, Object>(){

        @Override
        protected Object convert(Object value) {
            return value;
        }
    };

    protected IMObjectAssembler(Class<? extends org.openvpms.component.model.object.IMObject> type, Class<T> typeImpl, Class<DO> typeDO, Class<? extends IMObjectDOImpl> implDO) {
        this.type = type;
        this.typeImpl = typeImpl;
        this.typeDO = typeDO;
        this.implDO = implDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DOState assemble(IMObject source, Context context) {
        boolean assembling;
        IMObjectDO target = null;
        IMObject object = (IMObject)this.typeImpl.cast(source);
        DOState state = context.getCached(source);
        if (state == null) {
            if (source.isNew()) {
                target = (IMObjectDO)this.create((T)object);
                target.setId(source.getId());
                target.setLinkId(source.getLinkId());
                target.setArchetypeId(source.getArchetypeId());
            } else {
                target = this.load(source.getObjectReference(), this.typeDO, this.implDO, context);
                target = this.deproxy(target);
            }
            state = new DOState(target, source);
            assembling = false;
        } else {
            assembling = context.isAssembling(state);
            if (!assembling) {
                target = (IMObjectDO)this.typeDO.cast(state.getObject());
                state.update(source);
            }
        }
        if (!assembling) {
            context.add(state, source);
            try {
                context.addAssembling(state);
                this.assembleDO(target, object, state, context);
            }
            finally {
                context.removeAssembling(state);
            }
        }
        return state;
    }

    @Override
    public DOState assemble(Reference source, Context context) {
        DOState state = context.getCached(source);
        if (state == null) {
            DO target = this.load(source, this.typeDO, this.implDO, context);
            target = this.deproxy(target);
            state = new DOState((IMObjectDO)target);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DOState assemble(IMObjectDO target, IMObject source, Context context) {
        boolean assembling;
        DOState state = context.getCached(source);
        if (state == null) {
            state = new DOState(target, source);
            assembling = false;
        } else {
            assembling = context.isAssembling(state);
            target = (IMObjectDO)this.typeDO.cast(state.getObject());
            state.update(source);
        }
        if (!assembling) {
            context.add(state, source);
            try {
                context.addAssembling(state);
                this.assembleDO((IMObjectDO)this.typeDO.cast(target), (IMObject)this.typeImpl.cast(source), state, context);
            }
            finally {
                context.removeAssembling(state);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMObject assemble(IMObjectDO source, Context context) {
        IMObjectDO object = (IMObjectDO)this.typeDO.cast(source);
        IMObject target = (IMObject)this.typeImpl.cast(context.getCached(source));
        if (target == null) {
            target = this.create((T)object);
            context.add(target, source);
            try {
                context.addAssembling(target);
                this.assembleObject(target, object, context);
            }
            finally {
                context.removeAssembling(target);
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMObject assemble(IMObject target, IMObjectDO source, Context context) {
        if (!context.isAssembling(target)) {
            try {
                context.addAssembling(target);
                this.assembleObject((IMObject)this.typeImpl.cast(target), (IMObjectDO)this.typeDO.cast(source), context);
            }
            finally {
                context.removeAssembling(target);
            }
        }
        return target;
    }

    public Class<? extends org.openvpms.component.model.object.IMObject> getType() {
        return this.type;
    }

    public Class<? extends IMObject> getTypeImpl() {
        return this.typeImpl;
    }

    public Class<? extends IMObjectDO> getDOType() {
        return this.typeDO;
    }

    public Class<? extends IMObjectDOImpl> getDOImplType() {
        return this.implDO;
    }

    public static Timestamp getTimestamp(Date date) {
        if (date != null) {
            long ms = date.getTime();
            return IMObjectAssembler.getTimestamp(ms);
        }
        return null;
    }

    public static Timestamp getTimestampNow() {
        return IMObjectAssembler.getTimestamp(System.currentTimeMillis());
    }

    protected void assembleDO(DO target, T source, DOState state, Context context) {
        if (target.getId() != ((IMObject)source).getId()) {
            target.setId(((IMObject)source).getId());
        }
        if (!Objects.equals(target.getLinkId(), ((IMObject)source).getLinkId())) {
            target.setLinkId(((IMObject)source).getLinkId());
        }
        if (!Objects.equals(target.getArchetypeId(), ((IMObject)source).getArchetypeId())) {
            target.setArchetypeId(((IMObject)source).getArchetypeId());
        }
        if (target.getVersion() != ((IMObject)source).getVersion()) {
            target.setVersion(((IMObject)source).getVersion());
        }
        if (target.isActive() != ((IMObject)source).isActive()) {
            target.setActive(((IMObject)source).isActive());
        }
        if (!Objects.equals(target.getDescription(), ((IMObject)source).getDescription())) {
            target.setDescription(((IMObject)source).getDescription());
        }
        if (!Objects.equals(target.getName(), ((IMObject)source).getName())) {
            target.setName(((IMObject)source).getName());
        }
        DETAILS.convert(target.getDetails(), ((IMObject)source).getDetails());
    }

    protected void assembleObject(T target, DO source, Context context) {
        ((IMObject)target).setId(source.getId());
        ((IMObject)target).setLinkId(source.getLinkId());
        ((IMObject)target).setArchetypeId(source.getArchetypeId());
        ((IMObject)target).setVersion(source.getVersion());
        ((IMObject)target).setActive(source.isActive());
        ((IMObject)target).setDescription(source.getDescription());
        ((IMObject)target).setName(source.getName());
        DETAILS.convert(((IMObject)target).getDetails(), source.getDetails());
    }

    protected abstract T create(DO var1);

    protected abstract DO create(T var1);

    protected void assembleCreatedByRef(final AuditableIMObject target, AuditableIMObjectDO source, Context context) {
        UserDO user = source.getCreatedBy();
        if (user != null) {
            if (Hibernate.isInitialized((Object)user)) {
                target.setCreatedBy((Reference)context.getReference(user, UserDOImpl.class));
            } else {
                context.addDeferredReference(new DeferredReference(user, UserDOImpl.class){

                    @Override
                    public void update(IMObjectReference reference) {
                        target.setCreatedBy((Reference)reference);
                    }
                });
            }
        } else {
            target.setCreatedBy(null);
        }
    }

    protected void assembleUpdatedByRef(final AuditableIMObject target, AuditableIMObjectDO source, Context context) {
        UserDO user = source.getUpdatedBy();
        if (user != null) {
            if (Hibernate.isInitialized((Object)user)) {
                target.setUpdatedBy((Reference)context.getReference(user, UserDOImpl.class));
            } else {
                context.addDeferredReference(new DeferredReference(user, UserDOImpl.class){

                    @Override
                    public void update(IMObjectReference reference) {
                        target.setUpdatedBy((Reference)reference);
                    }
                });
            }
        } else {
            target.setUpdatedBy(null);
        }
    }

    private static Timestamp getTimestamp(long time) {
        time -= time % 1000L;
        return new Timestamp(time);
    }
}

