/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.openvpms.component.business.dao.hibernate.cache.ArchetypeIdCache;
import org.openvpms.component.business.dao.hibernate.im.common.Assembler;
import org.openvpms.component.business.dao.hibernate.im.common.ContextHandler;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.DeferredReference;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.object.Reference;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class Context {
    private final Assembler assembler;
    private final Session session;
    private final ResourceKey key;
    private final boolean syncActive;
    private final ArchetypeIdCache archetypeIds;
    private final Map<IMObject, DOState> objectToDOMap = new HashMap<IMObject, DOState>();
    private final Map<IMObjectDO, IMObject> doToObjectMap = new HashMap<IMObjectDO, IMObject>();
    private final Map<Reference, DOState> refToDOMap = new HashMap<Reference, DOState>();
    private final Set<DOState> saved = new HashSet<DOState>();
    private final Set<DOState> saveDeferred = new LinkedHashSet<DOState>();
    private final Map<Object, Object> assembling = new IdentityHashMap<Object, Object>();
    private final List<DeferredReference> deferredRefs = new ArrayList<DeferredReference>();
    private ContextHandler handler;

    private Context(Assembler assembler, Session session, boolean syncActive, ArchetypeIdCache archetypeIds) {
        this.assembler = assembler;
        this.session = session;
        this.syncActive = syncActive;
        this.archetypeIds = archetypeIds;
        this.key = new ResourceKey(session);
    }

    public void setContextHandler(ContextHandler handler) {
        this.handler = handler;
    }

    public Assembler getAssembler() {
        return this.assembler;
    }

    public void addAssembling(DOState state) {
        this.assembling.put(state, state);
    }

    public void removeAssembling(DOState state) {
        this.assembling.remove(state);
    }

    public boolean isAssembling(DOState state) {
        return this.assembling.containsKey(state);
    }

    public void addAssembling(IMObject object) {
        this.assembling.put(object, object);
    }

    public void removeAssembling(IMObject object) {
        this.assembling.remove(object);
    }

    public boolean isAssembling(IMObject object) {
        return this.assembling.containsKey(object);
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isSynchronizationActive() {
        return this.syncActive;
    }

    public void add(DOState target, IMObject source) {
        this.objectToDOMap.put(source, target);
        this.doToObjectMap.put(target.getObject(), source);
        this.refToDOMap.put(source.getObjectReference(), target);
    }

    public void add(IMObject target, IMObjectDO source) {
        this.doToObjectMap.put(source, target);
    }

    public void remove(IMObjectDO target) {
        IMObject source = this.doToObjectMap.get(target);
        this.session.delete((Object)target);
        this.doToObjectMap.remove(target);
        if (source != null) {
            DOState state = this.objectToDOMap.get(source);
            this.objectToDOMap.remove(source);
            this.refToDOMap.remove(source.getObjectReference());
            if (state != null) {
                this.saveDeferred.remove(state);
            }
        }
    }

    public DOState getCached(IMObject source) {
        return this.objectToDOMap.get(source);
    }

    public IMObject getCached(IMObjectDO source) {
        return this.doToObjectMap.get(source);
    }

    public DOState getCached(Reference reference) {
        return this.refToDOMap.get(reference);
    }

    public <T extends IMObjectDO, Impl extends IMObjectDOImpl> T get(Reference reference, Class<T> type, Class<Impl> impl) {
        Object result = this.session.load(impl, (Serializable)Long.valueOf(reference.getId()));
        return (T)((IMObjectDO)type.cast(result));
    }

    public void addDeferredReference(DeferredReference deferredReference) {
        this.deferredRefs.add(deferredReference);
    }

    public List<DeferredReference> getDeferredReferences() {
        return this.deferredRefs;
    }

    public IMObjectReference getReference(IMObjectDO object, Class<? extends IMObjectDOImpl> type) {
        if (Hibernate.isInitialized((Object)object)) {
            return object.getObjectReference();
        }
        Query query = this.session.createQuery("select archetypeId, linkId from " + type.getName() + " where id=?");
        query.setParameter(0, (Object)object.getId());
        List result = query.list();
        if (!result.isEmpty()) {
            Object[] values = (Object[])result.get(0);
            ArchetypeId archetypeId = this.archetypeIds.get((ArchetypeId)values[0]);
            return new IMObjectReference(archetypeId, object.getId(), (String)values[1]);
        }
        return null;
    }

    public Map<Long, IMObjectReference> getReferences(Map<Long, IMObjectDO> objects, Class<? extends IMObjectDOImpl> type) {
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, IMObjectReference> result = new HashMap<Long, IMObjectReference>();
        for (Map.Entry<Long, IMObjectDO> entry : objects.entrySet()) {
            IMObjectDO object = entry.getValue();
            if (Hibernate.isInitialized((Object)object)) {
                result.put(entry.getKey(), object.getObjectReference());
                continue;
            }
            ids.add(entry.getKey());
        }
        int size = ids.size();
        if (size > 1) {
            Collections.sort(ids);
        }
        Query query = this.session.createQuery("select id, archetypeId, linkId from " + type.getName() + " where id in (:ids)");
        query.setParameterList("ids", ids);
        for (Object match : query.list()) {
            Object[] values = (Object[])match;
            long id = (Long)values[0];
            ArchetypeId archetypeId = this.archetypeIds.get((ArchetypeId)values[1]);
            String linkId = (String)values[2];
            result.put(id, new IMObjectReference(archetypeId, id, linkId));
        }
        return result;
    }

    public void resolveDeferredReferences() {
        List<DeferredReference> deferred = this.getDeferredReferences();
        if (!deferred.isEmpty()) {
            HashMap<Class, List> map = new HashMap<Class, List>();
            for (DeferredReference deferredReference : deferred) {
                IMObjectDO object = deferredReference.getObject();
                if (Hibernate.isInitialized((Object)object)) {
                    deferredReference.update(object.getObjectReference());
                    continue;
                }
                List list = map.computeIfAbsent(deferredReference.getType(), k -> new ArrayList());
                list.add(deferredReference);
            }
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    Class type = (Class)entry.getKey();
                    List refs = (List)entry.getValue();
                    HashMap<Long, IMObjectDO> objects = new HashMap<Long, IMObjectDO>();
                    for (DeferredReference ref : refs) {
                        IMObjectDO object = ref.getObject();
                        objects.put(object.getId(), object);
                    }
                    Map<Long, IMObjectReference> resolvedRefs = this.getReferences(objects, type);
                    for (DeferredReference ref : refs) {
                        IMObjectReference resolved = resolvedRefs.get(ref.getObject().getId());
                        if (resolved == null) continue;
                        ref.update(resolved);
                    }
                }
                map.clear();
            }
            deferred.clear();
        }
    }

    public void commit() {
        DOState.updateIds(this.getSaved(), this);
    }

    public void rollback() {
        DOState.rollbackIds(this.getSaved());
    }

    public void destroy() {
        for (DOState state : this.objectToDOMap.values()) {
            state.destroy();
        }
        this.objectToDOMap.clear();
        this.doToObjectMap.clear();
        this.refToDOMap.clear();
        this.saved.clear();
        this.saveDeferred.clear();
    }

    public void addSaveDeferred(DOState state) {
        this.saveDeferred.add(state);
    }

    public Set<DOState> getSaveDeferred() {
        return this.saveDeferred;
    }

    public void removeSaveDeferred(DOState state) {
        this.saveDeferred.remove(state);
    }

    public void addSaved(DOState state) {
        this.saved.add(state);
    }

    public Set<DOState> getSaved() {
        return this.saved;
    }

    public static Context getContext(Session session, Assembler assembler, ArchetypeIdCache archetypeIds) {
        Context context;
        ResourceKey key = new ResourceKey(session);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            if (!TransactionSynchronizationManager.hasResource((Object)key)) {
                context = new Context(assembler, session, true, archetypeIds);
                TransactionSynchronizationManager.bindResource((Object)context.getResourceKey(), (Object)context);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new ContextSynchronization(context));
            } else {
                context = (Context)TransactionSynchronizationManager.getResource((Object)key);
            }
        } else {
            context = new Context(assembler, session, false, archetypeIds);
        }
        return context;
    }

    private Object getResourceKey() {
        return this.key;
    }

    private static class ResourceKey {
        private final Session session;

        public ResourceKey(Session session) {
            this.session = session;
        }

        public int hashCode() {
            return this.session.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ResourceKey && this.session.equals(((ResourceKey)obj).session);
        }
    }

    private static class ContextSynchronization
    extends TransactionSynchronizationAdapter {
        private final Context context;

        public ContextSynchronization(Context context) {
            this.context = context;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.context.getResourceKey());
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.context.getResourceKey(), (Object)this.context);
        }

        public void beforeCommit(boolean readOnly) {
            ContextHandler handler = this.context.handler;
            if (handler != null) {
                handler.preCommit(this.context);
            }
        }

        public void afterCompletion(int status) {
            TransactionSynchronizationManager.unbindResource((Object)this.context.getResourceKey());
            ContextHandler handler = this.context.handler;
            if (handler != null) {
                if (status == 0) {
                    handler.commit(this.context);
                } else {
                    handler.rollback(this.context);
                }
            }
            this.context.destroy();
        }
    }
}

