/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.cache;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.cache.CacheManager;
import javax.cache.spi.CachingProvider;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.jcache.internal.JCacheRegionFactory;
import org.hibernate.cache.spi.CacheKeysFactory;

public class WorkaroundJCacheRegionFactory
extends JCacheRegionFactory {
    public WorkaroundJCacheRegionFactory() {
    }

    public WorkaroundJCacheRegionFactory(CacheKeysFactory cacheKeysFactory) {
        super(cacheKeysFactory);
    }

    protected CacheManager resolveCacheManager(SessionFactoryOptions settings, Map properties) {
        URI cacheManagerUri;
        Object explicitCacheManager = properties.get("hibernate.javax.cache.cache_manager");
        if (explicitCacheManager != null) {
            return super.resolveCacheManager(settings, properties);
        }
        CachingProvider cachingProvider = this.getCachingProvider(properties);
        URI uri = cacheManagerUri = this.getUri(properties);
        try {
            uri.toURL();
        }
        catch (Exception e) {
            try {
                URL url = this.getClassLoader(cachingProvider).getResource(cacheManagerUri.toString());
                uri = url.toURI();
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Resource not found: " + uri, e1);
            }
        }
        CacheManager cacheManager = cacheManagerUri != null ? cachingProvider.getCacheManager(uri, this.getClassLoader(cachingProvider)) : cachingProvider.getCacheManager();
        return cacheManager;
    }
}

