/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.cache;

import java.util.HashMap;
import java.util.Map;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.archetype.ReadOnlyArchetypeId;

public class ArchetypeIdCache {
    private final Map<String, ArchetypeId> ids = new HashMap<String, ArchetypeId>();

    public ArchetypeId get(ArchetypeId archetypeId) {
        return this.get(archetypeId.getShortName(), archetypeId.getVersion());
    }

    public synchronized ArchetypeId get(String archetype, String version) {
        String qualified = archetype + "." + version;
        return this.ids.computeIfAbsent(qualified, s -> new ReadOnlyArchetypeId(archetype, version));
    }
}

