/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.resources.Resources;
import org.apache.commons.resources.ResourcesException;

public abstract class ResourcesBase
implements Resources {
    private String name = null;
    private boolean returnNull = true;

    public ResourcesBase() {
        this(null);
    }

    public ResourcesBase(String name) {
        this.name = name;
    }

    public void init() throws ResourcesException {
    }

    public void destroy() throws ResourcesException {
    }

    public abstract Iterator getKeys();

    public String getName() {
        return this.name;
    }

    public boolean isReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    public byte[] getBytes(String key, Locale locale, TimeZone timeZone) {
        String value = this.getString(key, locale, timeZone);
        if (value == null) {
            return null;
        }
        return value.getBytes();
    }

    public InputStream getInputStream(String key, Locale locale, TimeZone timeZone) {
        byte[] bytes = this.getBytes(key, locale, timeZone);
        if (bytes == null) {
            bytes = new byte[]{};
        }
        return new ByteArrayInputStream(bytes);
    }

    public abstract Object getObject(String var1, Locale var2, TimeZone var3);

    public Reader getReader(String key, Locale locale, TimeZone timeZone) {
        String value = this.getString(key, locale, timeZone);
        if (value == null) {
            return null;
        }
        return new StringReader(value);
    }

    public String getString(String key, Locale locale, TimeZone timeZone) {
        Object value = this.getObject(key, locale, timeZone);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }
}

