/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.resources.Resources;
import org.apache.commons.resources.ResourcesException;
import org.apache.commons.resources.ResourcesFactory;
import org.apache.commons.resources.impl.ResourceBundleResourcesFactory;

public class Messages
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$resources$Messages == null ? (class$org$apache$commons$resources$Messages = Messages.class$("org.apache.commons.resources.Messages")) : class$org$apache$commons$resources$Messages));
    protected Resources resources = null;
    protected static ResourcesFactory factory = null;
    static /* synthetic */ Class class$org$apache$commons$resources$Messages;

    public Messages(Resources resources) {
        this.resources = resources;
    }

    public Resources getResources() {
        return this.resources;
    }

    public String getMessage(String key) {
        return Messages.getMessage(this.resources, key);
    }

    public String getMessage(Locale locale, String key) {
        return Messages.getMessage(this.resources, locale, key);
    }

    public String getMessage(String key, Object[] args) {
        return Messages.getMessage(this.resources, key, args);
    }

    public String getMessage(Locale locale, String key, Object[] args) {
        return Messages.getMessage(this.resources, locale, key, args);
    }

    public String getMessage(String key, Object arg0) {
        return Messages.getMessage(this.resources, key, arg0);
    }

    public String getMessage(Locale locale, String key, Object arg0) {
        return Messages.getMessage(this.resources, locale, key, arg0);
    }

    public static String getMessage(Resources resources, String key) {
        return Messages.getMessage(resources, (Locale)null, key);
    }

    public static String getMessage(Resources resources, Locale locale, String key) {
        String message = null;
        try {
            message = resources.getString(key, locale, null);
        }
        catch (ResourcesException e) {
            log.debug((Object)("Failed retrieving message for key: '" + key + "'."), (Throwable)e);
        }
        if (message == null) {
            message = "???" + key + "???";
        }
        return message;
    }

    public static String getMessage(Resources resources, String key, Object[] args) {
        return Messages.getMessage(resources, (Locale)null, key, args);
    }

    public static String getMessage(Resources resources, Locale locale, String key, Object[] args) {
        String message = Messages.getMessage(resources, locale, key);
        MessageFormat format = new MessageFormat(message);
        return format.format(args);
    }

    public static String getMessage(Resources resources, String key, Object arg0) {
        return Messages.getMessage(resources, (Locale)null, key, arg0);
    }

    public static String getMessage(Resources resources, Locale locale, String key, Object arg0) {
        return Messages.getMessage(resources, locale, key, new Object[]{arg0});
    }

    public static Messages getMessages(String name) {
        if (factory == null) {
            factory = new ResourceBundleResourcesFactory();
        }
        try {
            Resources resources = factory.getResources(name);
            return new Messages(resources);
        }
        catch (ResourcesException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

