/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.pojorule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.rule.Rule;
import org.drools.spi.Tuple;
import org.drools.spring.pojorule.Argument;

public class RuleReflectMethod
implements Externalizable {
    private Rule rule;
    private Object pojo;
    private Method method;
    private Argument[] arguments;

    public RuleReflectMethod() {
    }

    public RuleReflectMethod(Rule rule, Object pojo, Method method, Argument[] arguments) {
        this.rule = rule;
        this.pojo = pojo;
        this.method = method;
        this.arguments = arguments;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Argument[] getArguments() {
        return this.arguments;
    }

    public Object invokeMethod(Tuple tuple) throws Exception {
        this.method.setAccessible(true);
        return this.method.invoke(this.pojo, this.getMethodArguments(tuple));
    }

    private Object[] getMethodArguments(Tuple tuple) {
        Object[] args = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            args[i] = this.arguments[i].getValue(tuple);
        }
        return args;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rule);
        out.writeObject(this.pojo);
        out.writeObject(this.method.getName());
        out.writeObject(this.method.getParameterTypes());
        out.writeObject(this.arguments);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rule = (Rule)in.readObject();
        this.pojo = in.readObject();
        String methodName = (String)in.readObject();
        Class[] parameterTypes = (Class[])in.readObject();
        try {
            this.method = this.pojo.getClass().getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.arguments = (Argument[])in.readObject();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RuleReflectMethod)) {
            return false;
        }
        RuleReflectMethod ruleReflectMethod = (RuleReflectMethod)other;
        if (!this.method.equals(ruleReflectMethod.method)) {
            return false;
        }
        return this.pojo.equals(ruleReflectMethod.pojo);
    }

    public int hashCode() {
        int result = this.pojo.hashCode();
        result = 29 * result + this.method.hashCode();
        return result;
    }

    public String toString() {
        return this.pojo.getClass().getName() + "." + this.method.getName() + "(" + this.toStringParamterTypes() + ")";
    }

    private String toStringParamterTypes() {
        return "...";
    }
}

