/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.factory;

import java.util.Iterator;
import java.util.Set;
import org.drools.DroolsException;
import org.drools.DroolsRuntimeException;
import org.drools.rule.DuplicateRuleNameException;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Rule;
import org.drools.rule.RuleSet;
import org.drools.spring.factory.RuleBean;
import org.drools.spring.factory.RuleBuilder;
import org.drools.spring.metadata.ArgumentMetadataSource;
import org.drools.spring.metadata.ChainedArgumentMetadataSource;
import org.drools.spring.metadata.ChainedMethodMetadataSource;
import org.drools.spring.metadata.ChainedRuleMetadataSource;
import org.drools.spring.metadata.MethodMetadataSource;
import org.drools.spring.metadata.RuleMetadata;
import org.drools.spring.metadata.RuleMetadataSource;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class RuleSetFactoryBean
implements FactoryBean,
BeanNameAware,
InitializingBean {
    private static RuleBuilder builder = new RuleBuilder();
    private String name;
    private ChainedRuleMetadataSource ruleMetadataSource;
    private ChainedMethodMetadataSource methodMetadataSource;
    private ChainedArgumentMetadataSource argumentMetadataSource;
    private Set rules;
    RuleSet ruleSet;

    public void setName(String name) {
        this.name = name;
    }

    public void setRuleMetadataSourceChain(RuleMetadataSource[] chain) {
        this.ruleMetadataSource = new ChainedRuleMetadataSource(chain);
    }

    public void setMethodMetadataSourceChain(MethodMetadataSource[] chain) {
        this.methodMetadataSource = new ChainedMethodMetadataSource(chain);
    }

    public void setArgumentMetadataSourceChain(ArgumentMetadataSource[] chain) {
        this.argumentMetadataSource = new ChainedArgumentMetadataSource(chain);
    }

    public void setRules(Set rules) {
        this.rules = rules;
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.rules == null || this.rules.isEmpty()) {
            throw new IllegalArgumentException("rules property not set or is empty");
        }
    }

    private RuleSet createObject() throws DuplicateRuleNameException, InvalidRuleException {
        RuleSet ruleSet = new RuleSet(this.name);
        Iterator iter = this.rules.iterator();
        while (iter.hasNext()) {
            Object rulesItem = iter.next();
            Rule rule = this.createRule(rulesItem);
            ruleSet.addRule(rule);
        }
        return ruleSet;
    }

    private Rule createRule(Object rulesItem) {
        RuleMetadata ruleMetadata;
        Object pojo;
        if (rulesItem instanceof RuleBean) {
            pojo = ((RuleBean)rulesItem).getPojo();
            ruleMetadata = ((RuleBean)rulesItem).getRuleMetadata();
        } else {
            pojo = rulesItem;
            ruleMetadata = this.ruleMetadataSource.getRuleMetadata(pojo.getClass());
        }
        Rule rule = new Rule(ruleMetadata.getName());
        this.setRuleProperties(rule, ruleMetadata);
        builder.setMethodMetadataSource(this.methodMetadataSource);
        builder.setArgumentMetadataSource(this.argumentMetadataSource);
        try {
            return builder.buildRule(rule, pojo);
        }
        catch (DroolsException e) {
            throw new DroolsRuntimeException(e);
        }
    }

    private void setRuleProperties(Rule rule, RuleMetadata ruleMetadata) {
        if (ruleMetadata.getDocumentation() != null) {
            rule.setDocumentation(ruleMetadata.getDocumentation());
        }
        if (ruleMetadata.getSalience() != null) {
            rule.setSalience(ruleMetadata.getSalience());
        }
        if (ruleMetadata.getDuration() != null) {
            rule.setDuration(ruleMetadata.getDuration());
        }
        if (ruleMetadata.getNoLoop() != null) {
            rule.setNoLoop(ruleMetadata.getNoLoop());
        }
    }

    public Object getObject() throws Exception {
        if (this.ruleSet == null) {
            this.ruleSet = this.createObject();
        }
        return this.ruleSet;
    }

    public Class getObjectType() {
        return RuleSet.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

