/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.examples.jiahvac.sim;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.drools.spring.examples.jiahvac.model.Floor;
import org.drools.spring.examples.jiahvac.sim.Simulator;

public class SimulatorGUI
implements Runnable {
    private Simulator simulator;
    private int floorCount;
    private JLabel[] labels;
    private JTextField outdoorField = new JTextField();

    public SimulatorGUI(Simulator simulator) {
        this.simulator = simulator;
        this.floorCount = simulator.getFloors().length;
        JFrame frame = this.createControls();
        this.renderFloors();
        frame.pack();
        frame.setVisible(true);
    }

    private JFrame createControls() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        JPanel floorsPanel = new JPanel();
        floorsPanel.setLayout(new GridLayout(this.floorCount, 1));
        this.labels = new JLabel[this.floorCount];
        for (int floorIndex = 0; floorIndex < this.floorCount; ++floorIndex) {
            JLabel label = new JLabel();
            label.setFont(new Font("Courier", 0, 12));
            this.labels[floorIndex] = label;
            floorsPanel.add(this.labels[floorIndex]);
        }
        String text = String.valueOf(this.simulator.getOutdoorTempurature());
        this.outdoorField.setText(text);
        this.outdoorField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                double value = Double.parseDouble(SimulatorGUI.this.outdoorField.getText());
                SimulatorGUI.this.simulator.setOutdoorTempurature(value);
            }
        });
        Container content = frame.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)floorsPanel, "Center");
        content.add((Component)this.outdoorField, "South");
        return frame;
    }

    public void run() {
        this.renderFloors();
    }

    private void renderFloors() {
        Floor[] floors = this.simulator.getFloors();
        for (int i = 0; i < floors.length; ++i) {
            Floor floor = floors[i];
            JLabel label = this.labels[i];
            label.setText(String.format("%2d) %3.2f - pump-%1d %-8s, vent %-8s", new Object[]{floor.getNumber() + 1, floor.getThermometer().getReading(), floor.getHeatPump().getId(), floor.getHeatPump().getState(), floor.getVent().getState()}));
        }
    }
}

