/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.examples.jiahvac.sim;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.drools.spring.examples.jiahvac.model.Thermometer;
import org.drools.spring.examples.jiahvac.sim.SimFloor;

public class SimThermometer
implements Thermometer {
    private final SimFloor floor;
    private double reading;
    private double prevReading;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public SimThermometer(SimFloor floor, double reading) {
        this.floor = floor;
        this.reading = reading;
        this.prevReading = reading - 1.0;
    }

    public SimThermometer(SimFloor floor) {
        this(floor, 0.0);
    }

    public SimFloor getFloor() {
        return this.floor;
    }

    public double getReading() {
        return this.reading;
    }

    public void setReading(double reading) {
        this.prevReading = this.reading;
        this.reading = reading;
        this.pcs.firePropertyChange("reading", new Double(this.prevReading), new Double(reading));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String toString() {
        return "t(" + this.floor.getNumber() + ")=" + this.reading;
    }
}

