/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.codehaus.janino.Scanner;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.java.CompilationException;
import org.drools.semantics.java.JavaCompiler;
import org.drools.semantics.java.JavaExprAnalyzer;
import org.drools.spi.Condition;
import org.drools.spi.ConditionException;
import org.drools.spi.DefaultKnowledgeHelper;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Tuple;

public class JavaCondition
implements Serializable,
Condition {
    private final String originalExpression;
    private final Rule rule;
    private final String expression;
    private final Declaration[] requiredDeclarations;
    private final String className;
    private transient Script script;

    protected JavaCondition(Rule rule, int id, String expression) throws Exception {
        this.originalExpression = expression;
        this.expression = "return (" + expression + ");";
        this.rule = rule;
        JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
        List requiredDecls = analyzer.analyze(expression, rule.getParameterDeclarations());
        this.requiredDeclarations = requiredDecls.toArray(new Declaration[requiredDecls.size()]);
        this.className = "Condition_" + id;
        this.script = this.compile();
    }

    public boolean isAllowed(Tuple tuple) throws ConditionException {
        try {
            if (this.script == null) {
                this.script = this.compile();
            }
            return this.script.invoke(tuple, this.requiredDeclarations, new DefaultKnowledgeHelper(this.rule, tuple), tuple.getWorkingMemory().getApplicationDataMap());
        }
        catch (Scanner.LocatedException e) {
            throw new ConditionException(e, this.rule, this.originalExpression);
        }
        catch (CompilationException e) {
            throw new ConditionException(e.getMessage(), e.getRule(), e.getText());
        }
        catch (Exception e) {
            throw new ConditionException(e, this.rule, this.originalExpression);
        }
    }

    public Declaration[] getRequiredTupleMembers() {
        return this.requiredDeclarations;
    }

    private Script compile() throws Exception {
        return (Script)JavaCompiler.compile(this.rule, this.className, Script.class, this.expression, this.originalExpression, this.requiredDeclarations);
    }

    public int hashCode() {
        return this.originalExpression.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.originalExpression.equals(((JavaCondition)object).originalExpression);
    }

    public String toString() {
        return "[Condition: " + this.originalExpression + "]";
    }

    public static interface Script {
        public boolean invoke(Tuple var1, Declaration[] var2, KnowledgeHelper var3, Map var4) throws Exception;
    }
}

