/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.groovy.GroovyCondition;
import org.drools.spi.DefaultKnowledgeHelper;
import org.drools.spi.Functions;
import org.drools.spi.RuleBaseContext;
import org.drools.spi.Tuple;

public class GroovyInterp
implements Serializable {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final String originalText;
    private String text;
    private final Rule rule;
    private transient Script code;

    protected GroovyInterp(String text, Rule rule) {
        this.rule = rule;
        this.originalText = text;
        try {
            StringBuffer newText = new StringBuffer();
            Iterator it = rule.getImporter().getImports().iterator();
            while (it.hasNext()) {
                newText.append("import ");
                newText.append(it.next());
                newText.append(";");
                newText.append(LINE_SEPARATOR);
            }
            Functions functions = this.rule.getRuleSet().getFunctions("groovy");
            if (functions != null) {
                newText.append(functions.getText());
            }
            if (this instanceof GroovyCondition) {
                text = "return (" + text + ")";
            }
            newText.append(text);
            this.text = newText.toString();
            this.code = this.buildScript();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public String getText() {
        return this.originalText;
    }

    protected Script getCode() {
        if (this.code == null) {
            try {
                this.code = this.buildScript();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
        }
        return this.code;
    }

    protected Rule getRule() {
        return this.rule;
    }

    protected Binding setUpDictionary(Tuple tuple, Iterator declIter) {
        Binding dict = new Binding();
        while (declIter.hasNext()) {
            Declaration eachDecl = (Declaration)declIter.next();
            dict.setVariable(eachDecl.getIdentifier().intern(), tuple.get(eachDecl));
        }
        WorkingMemory workingMemory = tuple.getWorkingMemory();
        dict.setVariable("drools".intern(), (Object)new DefaultKnowledgeHelper(this.rule, tuple));
        Map appDataMap = workingMemory.getApplicationDataMap();
        Iterator keyIter = appDataMap.keySet().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            Object value = appDataMap.get(key);
            dict.setVariable(key, value);
        }
        return dict;
    }

    private Script buildScript() throws Exception {
        GroovyCodeSource codeSource = new GroovyCodeSource(this.text, "groovy.script", "groovy.script");
        RuleBaseContext ruleBaseContext = this.rule.getRuleSet().getRuleBaseContext();
        ClassLoader cl = (ClassLoader)ruleBaseContext.get("smf-classLoader");
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
            ruleBaseContext.put("smf-classLoader", cl);
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
            ruleBaseContext.put("smf-classLoader", cl);
        }
        GroovyClassLoader loader = new GroovyClassLoader(cl);
        Class clazz = loader.parseClass(codeSource);
        return (Script)clazz.newInstance();
    }
}

