/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import foxtrot.Job;
import foxtrot.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.drools.examples.conway.CellGrid;
import org.drools.examples.conway.ConwayApplicationProperties;
import org.drools.examples.conway.patterns.ConwayPattern;
import org.drools.examples.conway.ui.CellGridCanvas;

public class ConwayGUI
extends JPanel {
    private final JButton nextGenerationButton;
    private final JButton startStopButton;
    private final JButton clearButton;
    private final JComboBox patternSelector = new JComboBox();
    private final Timer timer;
    static /* synthetic */ Class class$org$drools$examples$conway$patterns$ConwayPattern;

    public ConwayGUI() {
        super(new BorderLayout());
        String nextGenerationLabel = ConwayApplicationProperties.getProperty("next.generation.label");
        this.nextGenerationButton = new JButton(nextGenerationLabel);
        String startLabel = ConwayApplicationProperties.getProperty("start.label");
        this.startStopButton = new JButton(startLabel);
        String clearLabel = ConwayApplicationProperties.getProperty("clear.label");
        this.clearButton = new JButton(clearLabel);
        final CellGrid grid = new CellGrid(30, 30);
        final CellGridCanvas canvas = new CellGridCanvas(grid);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", canvas);
        Border etchedBorder = BorderFactory.createEtchedBorder(1);
        Border outerBlankBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border innerBlankBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(outerBlankBorder, etchedBorder), innerBlankBorder);
        panel.setBorder(border);
        this.add("Center", panel);
        this.add("East", this.createControlPanel());
        this.nextGenerationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Worker.post((Job)new Job(){

                    public Object run() {
                        grid.nextGeneration();
                        return null;
                    }
                });
                canvas.repaint();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Worker.post((Job)new Job(){

                    public Object run() {
                        grid.killAll();
                        return null;
                    }
                });
                canvas.repaint();
            }
        });
        ActionListener timerAction = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Worker.post((Job)new Job(){

                    public Object run() {
                        if (!grid.nextGeneration()) {
                            ConwayGUI.this.stopTimer();
                        }
                        return null;
                    }
                });
                canvas.repaint();
            }
        };
        this.timer = new Timer(500, timerAction);
        this.startStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ConwayGUI.this.timer.isRunning()) {
                    ConwayGUI.this.stopTimer();
                } else {
                    ConwayGUI.this.startTimer();
                }
            }
        });
        this.populatePatternSelector();
        this.patternSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConwayPattern pattern = (ConwayPattern)ConwayGUI.this.patternSelector.getSelectedItem();
                if (pattern != null) {
                    grid.setPattern(pattern);
                    canvas.repaint();
                }
            }
        });
        this.patternSelector.setSelectedIndex(-1);
    }

    private void populatePatternSelector() {
        String patternClassNames = ConwayApplicationProperties.getProperty("conway.pattern.classnames");
        StringTokenizer tokenizer = new StringTokenizer(patternClassNames);
        String className = null;
        while (tokenizer.hasMoreTokens()) {
            className = tokenizer.nextToken().trim();
            try {
                Class<?> clazz = Class.forName(className);
                if ((class$org$drools$examples$conway$patterns$ConwayPattern == null ? ConwayGUI.class$("org.drools.examples.conway.patterns.ConwayPattern") : class$org$drools$examples$conway$patterns$ConwayPattern).isAssignableFrom(clazz)) {
                    this.patternSelector.addItem(clazz.newInstance());
                    continue;
                }
                System.err.println("Invalid pattern class name: " + className);
            }
            catch (Exception e) {
                System.err.println("An error occurred populating patterns: ");
                e.printStackTrace();
            }
        }
    }

    private void startTimer() {
        String stopLabel = ConwayApplicationProperties.getProperty("stop.label");
        this.startStopButton.setText(stopLabel);
        this.nextGenerationButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.patternSelector.setEnabled(false);
        this.timer.start();
    }

    private void stopTimer() {
        this.timer.stop();
        String startLabel = ConwayApplicationProperties.getProperty("start.label");
        this.startStopButton.setText(startLabel);
        this.nextGenerationButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.patternSelector.setEnabled(true);
    }

    private JPanel createControlPanel() {
        FormLayout layout = new FormLayout("pref, 3dlu, pref, 3dlu:grow", "pref, 15dlu, pref, 15dlu, pref, 3dlu:grow, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        String title = ConwayApplicationProperties.getProperty("app.title");
        builder.addLabel(title, cc.xywh(1, 1, layout.getColumnCount(), 1));
        String info = ConwayApplicationProperties.getProperty("app.description");
        builder.addLabel(info, cc.xywh(1, 3, layout.getColumnCount(), 1));
        String patternLabel = ConwayApplicationProperties.getProperty("pattern.label");
        builder.addLabel(patternLabel, cc.xy(1, 5));
        builder.add((Component)this.patternSelector, cc.xy(3, 5));
        JPanel buttonPanel = ButtonBarFactory.buildLeftAlignedBar((JButton)this.nextGenerationButton, (JButton)this.startStopButton, (JButton)this.clearButton);
        builder.add((Component)buttonPanel, cc.xywh(1, 7, layout.getColumnCount(), 1));
        Border etchedBorder = BorderFactory.createEtchedBorder(1);
        Border outerBlankBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border innerBlankBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(outerBlankBorder, etchedBorder), innerBlankBorder);
        builder.setBorder((Border)border);
        return builder.getPanel();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: " + ConwayGUI.class.getName() + " [drl file]");
            return;
        }
        System.out.println("Using drl: " + args[0]);
        System.setProperty("conway.drl.file", args[0]);
        String appTitle = ConwayApplicationProperties.getProperty("app.title");
        JFrame f = new JFrame(appTitle);
        f.setResizable(false);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add("Center", new ConwayGUI());
        f.pack();
        f.setVisible(true);
    }
}

