/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway.rules;

import java.net.URL;
import org.drools.RuleBase;
import org.drools.examples.conway.CellGrid;
import org.drools.io.RuleBaseLoader;

public class RuleBaseFactory {
    private static RuleBaseFactory ourInstance = new RuleBaseFactory();
    private static final String DEFAULT_DRL_FILE = "conway.java.drl";
    private RuleBase ruleBase;

    public static RuleBaseFactory getInstance() {
        return ourInstance;
    }

    private RuleBaseFactory() {
        try {
            String conwayDrlFile = System.getProperty("conway.drl.file");
            if (conwayDrlFile == null) {
                System.err.println("conway.drl.file system property not specified. using default: conway.java.drl");
                conwayDrlFile = DEFAULT_DRL_FILE;
            }
            System.out.println("loading drl file: " + conwayDrlFile);
            URL resource = CellGrid.class.getResource(conwayDrlFile);
            this.ruleBase = RuleBaseLoader.loadFromUrl(resource);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable To Initialise RuleBaseFactory:\n" + e.getMessage());
        }
    }

    public static RuleBase getRuleBase() {
        return RuleBaseFactory.ourInstance.ruleBase;
    }
}

