/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.Map;
import org.drools.decisiontable.model.SnippetBuilder;
import org.drools.decisiontable.parser.DecisionTableParseException;

public class ActionType {
    public static final int CONDITION = 0;
    public static final int ACTION = 1;
    public static final int PRIORITY = 2;
    public static final int DURATION = 3;
    public static final int NAME = 4;
    int type;
    String value;

    ActionType(int actionType, String cellValue) {
        this.type = actionType;
        this.value = cellValue;
    }

    String getSnippet(String cellValue) {
        SnippetBuilder builder = new SnippetBuilder(this.value);
        return builder.build(cellValue);
    }

    public static void addNewActionType(Map actionTypeMap, String value, int column, int row) {
        if (value.toUpperCase().startsWith("C")) {
            actionTypeMap.put(new Integer(column), new ActionType(0, null));
        } else if (value.toUpperCase().startsWith("A")) {
            actionTypeMap.put(new Integer(column), new ActionType(1, null));
        } else if (value.toUpperCase().startsWith("P")) {
            actionTypeMap.put(new Integer(column), new ActionType(2, null));
        } else if (value.toUpperCase().startsWith("D")) {
            actionTypeMap.put(new Integer(column), new ActionType(3, null));
        } else if (value.toUpperCase().startsWith("N")) {
            actionTypeMap.put(new Integer(column), new ActionType(4, null));
        } else {
            throw new DecisionTableParseException("Should be CONDITION or ACTION row:" + row + " column:" + column + " - does not contain a leading C or A identifer.");
        }
    }
}

