/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.model;

public class SnippetBuilder {
    private static final String PARAM_PREFIX = "$";
    private static final String PARAM = "\\$param";
    private static final String PARAM_PREFIX_REGEX = "\\$";
    private String _template;

    public SnippetBuilder(String snippetTemplate) {
        this._template = snippetTemplate;
    }

    public String build(String cellValue) {
        if (this._template == null) {
            throw new RuntimeException("Script template is null - check for missing script definition.");
        }
        if (this._template.indexOf("$1") > 0) {
            return this.buildMulti(cellValue);
        }
        return this.buildSingle(cellValue);
    }

    private String buildMulti(String cellValue) {
        String[] cellVals = cellValue.split(",");
        String result = this._template;
        for (int paramNumber = 0; paramNumber < cellVals.length; ++paramNumber) {
            String regex = PARAM_PREFIX_REGEX + (paramNumber + 1);
            result = result.replaceAll(regex, cellVals[paramNumber].trim());
        }
        return result;
    }

    private String buildSingle(String cellValue) {
        return this._template.replaceAll(PARAM, cellValue);
    }
}

