/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.pentaho;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Shell;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.etl.load.LoaderHelper;
import org.openvpms.etl.load.Mapping;
import org.openvpms.etl.load.Mappings;
import org.openvpms.etl.load.NodeParser;
import org.openvpms.etl.load.SymbolicReferenceParser;
import org.openvpms.etl.pentaho.ApplicationContextMgr;
import org.openvpms.etl.pentaho.LoaderPlugin;
import org.openvpms.etl.pentaho.LoaderPluginData;
import org.openvpms.etl.pentaho.LoaderPluginDialog;
import org.openvpms.etl.pentaho.Messages;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Node;

@Step(id="OpenVPMSLoaderPlugin", name="LoaderPluginMeta.Name", description="LoaderPluginMeta.TooltipDesc", image="openvpms.svg", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Output", i18nPackageName="org.openvpms.etl.pentaho")
public class LoaderPluginMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta database;
    private Mappings mappings = new Mappings();
    private static final String CONNECTION = "connection";
    private static final String ID_COLUMN = "idColumn";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String VALUE = "value";
    private static final String EXCLUDE_NULL = "excludeNull";
    private static final String SKIP_PROCESSED = "skipProcessed";
    private static final String REMOVE_DEFAULT_OBJECTS = "removeDefaultObjects";
    private static final String BATCH_SIZE = "batchSize";

    public LoaderPluginMeta() {
    }

    public LoaderPluginMeta(Node stepNode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.loadXML(stepNode, databases, metaStore);
    }

    public LoaderPluginMeta(Repository repository, IMetaStore metaStore, ObjectId stepId, List<DatabaseMeta> databases) throws KettleException {
        this.readRep(repository, metaStore, stepId, databases);
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new LoaderPluginDialog(shell, (LoaderPluginMeta)meta, transMeta, name);
    }

    public void setDefault() {
        this.mappings = new Mappings();
    }

    public Object clone() {
        LoaderPluginMeta result = (LoaderPluginMeta)((Object)super.clone());
        if (result != null) {
            StringWriter writer = new StringWriter();
            try {
                Marshaller.marshal((Object)this.mappings, (Writer)writer);
                String xml = writer.toString();
                result.mappings = (Mappings)Unmarshaller.unmarshal(Mappings.class, (Reader)new StringReader(xml));
            }
            catch (Exception exception) {
                this.logError("Failed to copy mappings", exception);
                result = null;
            }
        }
        return result;
    }

    public String getXML() {
        String result = "";
        if (this.mappings != null) {
            StringWriter writer = new StringWriter();
            try {
                Marshaller marshaller = new Marshaller((Writer)writer);
                marshaller.setSupressXMLDeclaration(true);
                marshaller.marshal((Object)this.mappings);
                result = writer.toString();
            }
            catch (Exception exception) {
                this.logError("Failed to generate XML for LoaderPluginMeta", exception);
            }
        }
        return result;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            Node node = XMLHandler.getSubNode((Node)stepnode, (String)"mappings");
            this.mappings = (Mappings)Unmarshaller.unmarshal(Mappings.class, (Node)node);
            this.database = DatabaseMeta.findDatabase(databases, (String)this.mappings.getConnection());
        }
        catch (Exception exception) {
            throw new KettleXMLException("Unable to read step info from XML node", (Throwable)exception);
        }
    }

    public void readRep(Repository repository, IMetaStore metaStore, ObjectId stepId, List<DatabaseMeta> databases) throws KettleException {
        this.mappings = new Mappings();
        String connection = this.repository.getStepAttributeString(stepId, CONNECTION);
        this.mappings.setConnection(connection);
        this.database = DatabaseMeta.findDatabase(databases, (String)connection);
        String idColumn = this.repository.getStepAttributeString(stepId, ID_COLUMN);
        this.mappings.setIdColumn(idColumn);
        this.mappings.setSkipProcessed(this.repository.getStepAttributeBoolean(stepId, SKIP_PROCESSED));
        this.mappings.setBatchSize((long)((int)this.repository.getStepAttributeInteger(stepId, BATCH_SIZE)));
        int count = this.repository.countNrStepAttributes(stepId, SOURCE);
        for (int i = 0; i < count; ++i) {
            String source = this.repository.getStepAttributeString(stepId, i, SOURCE);
            String target = this.repository.getStepAttributeString(stepId, i, TARGET);
            String value = this.repository.getStepAttributeString(stepId, i, VALUE);
            boolean excludeNull = this.repository.getStepAttributeBoolean(stepId, i, EXCLUDE_NULL);
            boolean removeDefaultObjects = this.repository.getStepAttributeBoolean(stepId, i, REMOVE_DEFAULT_OBJECTS);
            Mapping mapping = new Mapping();
            mapping.setSource(source);
            mapping.setTarget(target);
            mapping.setValue(value);
            mapping.setExcludeNull(excludeNull);
            mapping.setRemoveDefaultObjects(removeDefaultObjects);
            this.mappings.addMapping(mapping);
        }
    }

    public void saveRep(Repository repository, IMetaStore metaStore, ObjectId transformationId, ObjectId stepId) throws KettleException {
        repository.saveStepAttribute(transformationId, stepId, CONNECTION, this.mappings.getConnection());
        repository.saveStepAttribute(transformationId, stepId, ID_COLUMN, this.mappings.getIdColumn());
        repository.saveStepAttribute(transformationId, stepId, SKIP_PROCESSED, this.mappings.getSkipProcessed());
        repository.saveStepAttribute(transformationId, stepId, BATCH_SIZE, this.mappings.getBatchSize());
        for (int i = 0; i < this.mappings.getMappingCount(); ++i) {
            Mapping mapping = this.mappings.getMapping(i);
            repository.saveStepAttribute(transformationId, stepId, i, SOURCE, mapping.getSource());
            repository.saveStepAttribute(transformationId, stepId, i, TARGET, mapping.getTarget());
            repository.saveStepAttribute(transformationId, stepId, i, VALUE, mapping.getValue());
            repository.saveStepAttribute(transformationId, stepId, i, EXCLUDE_NULL, mapping.getExcludeNull());
            repository.saveStepAttribute(transformationId, stepId, i, REMOVE_DEFAULT_OBJECTS, mapping.getRemoveDefaultObjects());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(LoaderPluginMeta.class.getClassLoader());
            if (this.database == null) {
                this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.NoConnection", new Object[0]);
            }
            if (prev == null || prev.size() == 0) {
                this.addRemark(remarks, 3, stepMeta, "LoaderPluginMeta.NoFields", new Object[0]);
            } else {
                String idColumn = this.mappings.getIdColumn();
                if (StringUtils.isEmpty((CharSequence)idColumn)) {
                    this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.NoId", new Object[0]);
                } else if (prev.searchValueMeta(idColumn) == null) {
                    this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.NoField", idColumn);
                }
                IArchetypeService service = this.getService();
                for (Mapping mapping : this.mappings.getMapping()) {
                    this.checkMapping(remarks, mapping, prev, stepMeta, service);
                }
                this.addRemark(remarks, 1, stepMeta, "LoaderPluginMeta.StepConnected", prev.size());
            }
            if (input.length > 0) {
                this.addRemark(remarks, 1, stepMeta, "LoaderPluginMeta.StepReceiveInput", new Object[0]);
            } else {
                this.addRemark(remarks, 1, stepMeta, "LoaderPluginMeta.StepReceiveNoInput", new Object[0]);
            }
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepData, int copyNr, TransMeta transMeta, Trans trans) {
        LoaderPluginData data = (LoaderPluginData)stepData;
        data.setContext(this.getContext());
        return new LoaderPlugin(stepMeta, data, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new LoaderPluginData();
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    protected ApplicationContext getContext() {
        ApplicationContext context = null;
        if (this.database != null) {
            try {
                context = ApplicationContextMgr.getContext(this.database, this.getLog());
            }
            catch (Exception exception) {
                this.logError("Failed to load application context", exception);
            }
        } else {
            this.logError("Failed to load application context", new Object[]{Messages.get("LoaderPluginMeta.NoConnection", new Object[0])});
        }
        return context;
    }

    private void checkMapping(List<CheckResultInterface> remarks, Mapping mapping, RowMetaInterface row, StepMeta stepMeta, IArchetypeService service) {
        org.openvpms.etl.load.Node node;
        if (row.searchValueMeta(mapping.getSource()) == null) {
            this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.NoField", mapping.getSource());
        }
        if ((node = NodeParser.parse((String)mapping.getTarget())) == null) {
            this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.InvalidMapping", mapping.getSource(), mapping.getTarget());
        } else if (service != null) {
            while (node != null) {
                this.checkNode(remarks, node, mapping, stepMeta, service);
                node = node.getChild();
            }
        }
    }

    private void checkNode(List<CheckResultInterface> remarks, org.openvpms.etl.load.Node node, Mapping mapping, StepMeta stepMeta, IArchetypeService service) {
        ArchetypeDescriptor archetype = service.getArchetypeDescriptor(node.getArchetype());
        if (archetype == null) {
            this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.InvalidArchetype", node.getArchetype(), mapping.getTarget());
        } else {
            NodeDescriptor descriptor = archetype.getNodeDescriptor(node.getName());
            if (descriptor == null) {
                this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.InvalidNode", node.getArchetype(), node.getName(), mapping.getTarget());
            } else {
                this.checkNode(remarks, node, mapping, stepMeta, descriptor);
            }
        }
    }

    private void checkNode(List<CheckResultInterface> remarks, org.openvpms.etl.load.Node node, Mapping mapping, StepMeta stepMeta, NodeDescriptor descriptor) {
        String ref;
        boolean checkReference = false;
        if (descriptor.isCollection()) {
            checkReference = true;
            if (node.getIndex() < 0) {
                this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.ExpectedCollection", node.getArchetype(), node.getName(), mapping.getTarget());
            }
        } else {
            if (node.getIndex() >= 0) {
                this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.NodeNotCollection", node.getArchetype(), node.getName(), mapping.getTarget());
            }
            if (descriptor.isObjectReference()) {
                checkReference = true;
            }
        }
        if (checkReference && !StringUtils.isEmpty((CharSequence)mapping.getValue()) && SymbolicReferenceParser.parse((String)(ref = LoaderHelper.replaceValue((String)mapping.getValue(), (String)"dummy"))) == null) {
            this.addRemark(remarks, 4, stepMeta, "LoaderPluginMeta.InvalidReference", mapping.getValue(), mapping.getTarget());
        }
    }

    private void addRemark(List<CheckResultInterface> remarks, int type, StepMeta stepMeta, String key, Object ... args) {
        CheckResult remark = new CheckResult(type, Messages.get(key, args), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)remark);
    }

    private IArchetypeService getService() {
        ApplicationContext context = this.getContext();
        return context != null ? (IArchetypeService)context.getBean("archetypeService", IArchetypeService.class) : null;
    }
}

