/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.pentaho;

import java.util.List;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.etl.load.ETLLogDAO;
import org.openvpms.etl.load.ErrorListener;
import org.openvpms.etl.pentaho.LoaderAdapter;
import org.openvpms.etl.pentaho.LoaderPluginData;
import org.openvpms.etl.pentaho.LoaderPluginMeta;
import org.openvpms.etl.pentaho.Messages;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.springframework.context.ApplicationContext;

public class LoaderPlugin
extends BaseStep
implements StepInterface {
    private LoaderPluginData data;
    private LoaderPluginMeta metaData;
    private LoaderAdapter loader;

    public LoaderPlugin(StepMeta stepMeta, LoaderPluginData data, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, (StepDataInterface)data, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRow(StepMetaInterface stepMeta, StepDataInterface stepData) throws KettleException {
        boolean result = false;
        this.metaData = (LoaderPluginMeta)stepMeta;
        this.data = (LoaderPluginData)stepData;
        Object[] row = this.getRow();
        if (row != null) {
            if (this.first) {
                this.first = false;
                this.data.setRowMeta(this.getInputRowMeta().clone());
            }
            ClassLoader prior = this.setClassLoader();
            try {
                List<IMObject> loaded = this.loader.load(this.data.getRowMeta(), row);
                if (loaded.isEmpty()) {
                    this.incrementLinesSkipped();
                } else {
                    this.setLinesOutput(this.getLinesOutput() + (long)loaded.size());
                }
            }
            finally {
                this.setClassLoader(prior);
            }
            this.putRow(this.data.getRowMeta(), row);
            result = true;
            long read = this.getLinesRead();
            if (this.checkFeedback(read)) {
                this.logBasic(Messages.get("LoaderPlugin.Processed", read));
            }
        } else {
            this.setOutputDone();
        }
        return result;
    }

    public boolean init(StepMetaInterface stepMeta, StepDataInterface stepData) {
        this.metaData = (LoaderPluginMeta)stepMeta;
        this.data = (LoaderPluginData)stepData;
        try {
            this.initLoader();
        }
        catch (Exception exception) {
            return false;
        }
        return super.init(stepMeta, stepData);
    }

    public void dispose(StepMetaInterface stepMeta, StepDataInterface stepData) {
        this.metaData = (LoaderPluginMeta)stepMeta;
        this.data = (LoaderPluginData)stepData;
        try {
            this.closeLoader();
        }
        catch (Exception exception) {
            this.logError(Messages.get("LoaderPlugin.UnexpectedError", exception.getMessage()));
            this.logError(Const.getStackTracker((Throwable)exception));
        }
        super.dispose(stepMeta, stepData);
    }

    private void initLoader() throws KettleException {
        if (this.loader == null) {
            ApplicationContext context = this.data.getContext();
            if (context == null) {
                throw new KettleException(Messages.get("LoaderPlugin.NoContext", new Object[0]));
            }
            ETLLogDAO dao = (ETLLogDAO)context.getBean(ETLLogDAO.class);
            IArchetypeService service = (IArchetypeService)context.getBean("archetypeService");
            LookupService lookups = (LookupService)context.getBean(LookupService.class);
            this.loader = new LoaderAdapter(this.getStepname(), this.metaData.getMappings(), dao, service, lookups);
            this.loader.setErrorListener(new ErrorListener(){

                public void error(String legacyId, String message, Throwable exception) {
                    String msg = Messages.get("LoaderPlugin.FailedToProcessRow", legacyId, message);
                    LoaderPlugin.this.logError(msg, exception);
                }

                public void error(String message, Throwable exception) {
                    String msg = Messages.get("LoaderPlugin.FailedToProcess", message);
                    LoaderPlugin.this.logError(msg, exception);
                }
            });
        }
    }

    private void closeLoader() {
        if (this.loader != null) {
            ClassLoader prior = this.setClassLoader();
            try {
                this.loader.close();
            }
            finally {
                this.setClassLoader(prior);
            }
        }
    }

    private ClassLoader setClassLoader() {
        return this.setClassLoader(LoaderPlugin.class.getClassLoader());
    }

    private ClassLoader setClassLoader(ClassLoader loader) {
        Thread thread = Thread.currentThread();
        ClassLoader current = thread.getContextClassLoader();
        thread.setContextClassLoader(loader);
        return current;
    }
}

