/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.tools.reminder;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.DateStringParser;
import com.martiansoftware.jsap.stringparsers.LongStringParser;
import java.io.File;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ReminderTool {
    private final IArchetypeService service;
    private final PatientRules rules;
    private final ReminderTypes reminderTypes;
    private static final Logger log = LoggerFactory.getLogger(ReminderTool.class);
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";

    ReminderTool(IArchetypeRuleService service, PatientRules rules) {
        this.service = service;
        this.rules = rules;
        this.reminderTypes = new ReminderTypes((ArchetypeService)service);
    }

    public static void main(String[] args) {
        try {
            JSAP parser = ReminderTool.createParser();
            JSAPResult config = parser.parse(args);
            if (!config.success()) {
                ReminderTool.displayUsage(config);
            } else {
                java.util.Date due = config.getDate("due");
                long locationId = config.getLong("location", -1L);
                boolean updateNextReminder = config.getBoolean("updatenextreminder");
                boolean remove = config.getBoolean("remove");
                boolean dryRun = config.getBoolean("dryrun") || !config.getBoolean("commit");
                boolean updateCount = config.getBoolean("updatecount");
                if (updateNextReminder && (updateCount || remove)) {
                    ReminderTool.log("--update-next-reminder cannot be used in conjunction with --update-reminder-counts or --remove-unsent-items");
                    System.exit(1);
                } else if (updateNextReminder || remove || updateCount && due != null) {
                    String contextPath = config.getString("context");
                    Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
                    IArchetypeRuleService service = (IArchetypeRuleService)context.getBean(IArchetypeRuleService.class);
                    PatientRules rules = (PatientRules)context.getBean(PatientRules.class);
                    Entity location = null;
                    if (locationId != -1L) {
                        location = (Entity)service.get((Reference)new IMObjectReference("party.organisationLocation", locationId));
                        if (location == null) {
                            ReminderTool.log("ERROR: Failed to find practice location with id=" + locationId);
                            System.exit(1);
                        }
                        ReminderTool.log("Restricting reminders to customers with location=" + location.getName());
                    }
                    ReminderTool tool = new ReminderTool(service, rules);
                    Status status = new Status();
                    if (updateNextReminder) {
                        status = status.add(tool.updateNextReminderDates(location, dryRun));
                    } else {
                        if (remove) {
                            status = status.add(tool.removeUnsentItems(location, dryRun));
                        }
                        if (updateCount) {
                            status = status.add(tool.updateCounts(due, location, dryRun));
                        }
                    }
                    if (status.errors != 0) {
                        ReminderTool.log("WARNING: errors were encountered");
                    }
                    if (dryRun && status.updated != 0) {
                        ReminderTool.log("Use --commit to commit updates");
                    }
                    System.exit(0);
                } else {
                    ReminderTool.displayUsage(config);
                }
            }
        }
        catch (Throwable throwable) {
            log.error("ERROR: " + throwable.getMessage(), throwable);
            System.exit(1);
        }
    }

    private Status updateNextReminderDates(Entity location, boolean dryRun) {
        Status status = this.forEachReminder(location, act -> this.updateNextReminderDate((Act)act, dryRun));
        ReminderTool.log("Updated Next Reminder dates: updated=" + status.updated + ", skipped=" + status.skipped + ", errors=" + status.errors);
        return status;
    }

    private Status removeUnsentItems(Entity location, boolean dryRun) {
        Status status = this.forEachReminder(location, act -> this.removeUnsentItems((Act)act, dryRun));
        ReminderTool.log("Removed unsent items from reminders: updated=" + status.updated + ", skipped=" + status.skipped + ", errors=" + status.errors);
        return status;
    }

    private Status updateCounts(java.util.Date date, Entity location, boolean dryRun) {
        Status status = this.forEachReminder(location, act -> this.updateCount((Act)act, date, dryRun));
        ReminderTool.log("Update reminders: updated=" + status.updated + ", skipped=" + status.skipped + ", errors=" + status.errors);
        return status;
    }

    private Status updateNextReminderDate(Act act, boolean dryRun) {
        Status result;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        if (this.isValid(patient, act)) {
            ReminderType reminderType = this.getReminderType(bean);
            if (reminderType == null) {
                result = Status.skip();
                ReminderTool.log("Skipping reminder=" + act.getId() + " for patient=" + patient.getId() + ", name='" + patient.getName() + "': reminder has no reminder type");
            } else {
                int count = bean.getInt("reminderCount");
                java.util.Date date = reminderType.getNextDueDate(act.getActivityEndTime(), count);
                if (date == null) {
                    ReminderTool.log("Skipping reminder=" + act.getId() + " for patient=" + patient.getId() + ", name='" + patient.getName() + "': reminder type='" + reminderType.getName() + "' has no reminder count=" + count);
                    result = Status.skip();
                } else {
                    java.util.Date existing = act.getActivityStartTime();
                    if (existing.compareTo(date) != 0) {
                        RemoveStatus status;
                        act.setActivityStartTime(date);
                        List<Act> items = this.getUnsentItems(bean);
                        boolean error = false;
                        if (!items.isEmpty()) {
                            status = this.removeUnsentItems(act, bean, patient, items, dryRun);
                            if (!status.updated) {
                                error = true;
                            }
                        } else {
                            status = null;
                            if (!dryRun) {
                                boolean bl = error = !this.save(act, patient);
                            }
                        }
                        if (!error) {
                            result = Status.update();
                            String message = "Updated reminder=" + act.getId() + ", patient=" + ReminderTool.asString((Entity)patient) + ", from next reminder=" + this.asString(existing) + ", to next reminder=" + this.asString(date);
                            if (status != null) {
                                message = message + ": removed PENDING=" + status.pending + ", ERROR=" + status.errors;
                            }
                            ReminderTool.log(message);
                        } else {
                            result = Status.error();
                        }
                    } else {
                        result = Status.noop();
                    }
                }
            }
        } else {
            result = Status.error();
        }
        return result;
    }

    private Status removeUnsentItems(Act act, boolean dryRun) {
        Status result;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        if (this.isValid(patient, act)) {
            List<Act> items = this.getUnsentItems(bean);
            if (items.isEmpty()) {
                result = Status.noop();
            } else {
                RemoveStatus status = this.removeUnsentItems(act, bean, patient, items, dryRun);
                if (status.updated) {
                    ReminderTool.log("Updated reminder=" + act.getId() + ", patient=" + ReminderTool.asString((Entity)patient) + ", next reminder=" + this.asString(act.getActivityStartTime()) + ": removed PENDING=" + status.pending + ", ERROR=" + status.errors);
                    result = Status.update();
                } else {
                    result = Status.error();
                }
            }
        } else {
            result = Status.error();
        }
        return result;
    }

    private RemoveStatus removeUnsentItems(Act act, IMObjectBean bean, Party patient, List<Act> items, boolean dryRun) {
        ArrayList<Act> toSave = new ArrayList<Act>(items);
        int pending = 0;
        int errors = 0;
        for (Act item : items) {
            bean.removeTargets("items", (IMObject)item, "reminder");
            if ("PENDING".equals(item.getStatus())) {
                ++pending;
                continue;
            }
            ++errors;
        }
        toSave.add(act);
        boolean error = false;
        if (!dryRun) {
            error = !this.save(act, patient, toSave);
        }
        return new RemoveStatus(pending, errors, !error);
    }

    private boolean save(Act act, Party patient) {
        return this.save(act, patient, Collections.singletonList(act));
    }

    private boolean save(Act act, Party patient, List<Act> toSave) {
        boolean saved = false;
        try {
            this.service.save(toSave);
            saved = true;
        }
        catch (Throwable exception) {
            ReminderTool.log("Failed to update reminder=" + act.getId() + ", patient=" + ReminderTool.asString((Entity)patient) + ", next reminder=" + this.asString(act.getActivityStartTime()) + ": " + exception.getMessage());
            log.error(exception.getMessage(), exception);
        }
        return saved;
    }

    private boolean isValid(Party patient, Act act) {
        boolean valid = false;
        if (patient == null) {
            ReminderTool.log("Skipping reminder=" + act.getId() + ": reminder has no patient");
        } else if (!patient.isActive()) {
            ReminderTool.log("Skipping reminder=" + act.getId() + " for patient=" + ReminderTool.asString((Entity)patient) + ": patient is inactive");
        } else if (this.rules.isDeceased(patient)) {
            ReminderTool.log("Skipping reminder=" + act.getId() + " for patient=" + ReminderTool.asString((Entity)patient) + ": patient is deceased");
        } else {
            valid = true;
        }
        return valid;
    }

    private Status forEachReminder(Entity location, Function<Act, Status> function) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientReminder");
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"IN_PROGRESS"));
        if (location != null) {
            query.add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.join((String)"entity").add((IConstraint)Constraints.join((String)"customers").add((IConstraint)Constraints.join((String)"source", (String)"customer").add((IConstraint)Constraints.join((String)"practice").add((IConstraint)Constraints.eq((String)"target", (Object)location)))))));
        }
        query.add((IConstraint)Constraints.sort((String)"id"));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        Status result = new Status();
        while (iterator.hasNext()) {
            Act act = (Act)iterator.next();
            Status status = function.apply(act);
            result = result.add(status);
        }
        return result;
    }

    private Status updateCount(Act act, java.util.Date date, boolean dryRun) {
        Status result;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        if (this.isValid(patient, act)) {
            ReminderType reminderType = this.getReminderType(bean);
            if (reminderType == null) {
                result = Status.skip();
                ReminderTool.log("Skipping reminder=" + act.getId() + " for patient=" + patient.getId() + ", name='" + patient.getName() + "': reminder has no reminder type");
            } else if (act.getActivityStartTime().compareTo(date) < 0) {
                if (!dryRun && this.hasUnsentItems(bean)) {
                    ReminderTool.log("Skipping reminder=" + act.getId() + ", patient=" + ReminderTool.asString((Entity)patient) + ", reminderType=" + ReminderTool.asString(reminderType.getEntity()) + ": reminder has unsent reminder items");
                    result = Status.skip();
                } else {
                    result = this.updateReminderCountForPastDue(act, bean, patient, reminderType, date, dryRun);
                }
            } else {
                result = Status.noop();
            }
        } else {
            result = Status.error();
        }
        return result;
    }

    private Status updateReminderCountForPastDue(Act act, IMObjectBean bean, Party patient, ReminderType reminderType, java.util.Date date, boolean dryRun) {
        Status result;
        int count;
        boolean done = false;
        boolean updated = false;
        int oldCount = count = bean.getInt("reminderCount");
        java.util.Date oldDue = act.getActivityStartTime();
        while (!done && act.getActivityStartTime().compareTo(date) < 0) {
            java.util.Date dueDate = reminderType.getNextDueDate(act.getActivityEndTime(), ++count);
            if (dueDate != null) {
                bean.setValue("reminderCount", (Object)count);
                act.setActivityStartTime(dueDate);
                updated = true;
                continue;
            }
            if (reminderType.getReminderCount(count - 1) != null) {
                bean.setValue("reminderCount", (Object)count);
                updated = true;
            }
            done = true;
        }
        if (updated) {
            boolean error = false;
            if (!dryRun) {
                try {
                    this.service.save((IMObject)act);
                }
                catch (Throwable exception) {
                    error = true;
                    ReminderTool.log("Failed to update reminder=" + act.getId() + ", patient=" + ReminderTool.asString((Entity)patient) + ", reminderType=" + ReminderTool.asString(reminderType.getEntity()) + ", from count=" + oldCount + ", next reminder=" + this.asString(oldDue) + " to count=" + bean.getInt("reminderCount") + ", next reminder=" + this.asString(act.getActivityStartTime()) + ": " + exception.getMessage());
                    log.error(exception.getMessage(), exception);
                }
            }
            if (!error) {
                result = Status.update();
                ReminderTool.log("Updated reminder=" + act.getId() + ", patient=" + ReminderTool.asString((Entity)patient) + ", reminderType=" + ReminderTool.asString(reminderType.getEntity()) + ", from count=" + oldCount + ", next reminder=" + this.asString(oldDue) + " to count=" + bean.getInt("reminderCount") + ", next reminder=" + this.asString(act.getActivityStartTime()));
            } else {
                result = Status.error();
            }
        } else {
            result = Status.skip();
            ReminderTool.log("Skipping reminder=" + act.getId() + ", patient=" + ReminderTool.asString((Entity)patient) + ", reminderType=" + ReminderTool.asString(reminderType.getEntity()) + ", next reminder=" + this.asString(act.getActivityStartTime()) + ": no reminder count=" + count);
        }
        return result;
    }

    private static void log(String message) {
        System.out.println(message);
    }

    private boolean hasUnsentItems(IMObjectBean bean) {
        return !this.getUnsentItems(bean).isEmpty();
    }

    private List<Act> getUnsentItems(IMObjectBean bean) {
        ArrayList<Act> result = new ArrayList<Act>();
        for (Act act : bean.getTargets("items", Act.class)) {
            String status = act.getStatus();
            if (!"PENDING".equals(status) && !"ERROR".equals(status)) continue;
            result.add(act);
        }
        return result;
    }

    private ReminderType getReminderType(IMObjectBean bean) {
        Reference ref = bean.getTargetRef("reminderType");
        return this.reminderTypes.get(ref);
    }

    private String asString(java.util.Date date) {
        return new Date(date.getTime()).toString();
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter((Parameter)new Switch("updatenextreminder").setLongFlag("update-next-reminder").setDefault("false"));
        parser.registerParameter((Parameter)new Switch("updatecount").setLongFlag("update-reminder-counts").setDefault("false"));
        DateStringParser date = DateStringParser.getParser();
        date.setProperty("format", "dd/MM/yyyy");
        parser.registerParameter((Parameter)new FlaggedOption("due").setLongFlag("due").setStringParser((StringParser)date));
        parser.registerParameter((Parameter)new FlaggedOption("location").setLongFlag("location").setStringParser((StringParser)LongStringParser.getParser()));
        parser.registerParameter((Parameter)new Switch("remove").setLongFlag("remove-unsent-items").setDefault("false"));
        parser.registerParameter((Parameter)new Switch("dryrun").setLongFlag("dry-run"));
        parser.registerParameter((Parameter)new Switch("commit").setLongFlag("commit"));
        parser.registerParameter((Parameter)new Switch("help").setLongFlag("help").setDefault("false"));
        parser.registerParameter((Parameter)new FlaggedOption("context").setLongFlag("context").setDefault(APPLICATION_CONTEXT));
        return parser;
    }

    private static void displayUsage(JSAPResult result) {
        Iterator iter = result.getErrorMessageIterator();
        while (iter.hasNext()) {
            System.err.println(iter.next());
        }
        System.err.println();
        System.err.println("Usage: remtool [options]");
        System.err.println();
        System.err.println("  --update-next-reminder [ --location=<id> ] [--dry-run | --commit]");
        System.err.println("    For each IN_PROGRESS reminder, updates the Next Reminder date based on the current");
        System.err.println("    Reminder Type and Reminder Count");
        System.err.println("    If a reminder is updated, any reminder items with PENDING or ERROR status will be removed.");
        System.err.println();
        System.err.println("  --remove-unsent-items [ --location=<id> ] [--dry-run | --commit]");
        System.err.println("    For each IN_PROGRESS reminder, removes any reminder items with PENDING");
        System.err.println("    or ERROR status.");
        System.err.println();
        System.err.println("  --update-reminder-counts --due <dd/mm/yyyy> [ --location=<id> ] [--dry-run | --commit]");
        System.err.println("    For each IN_PROGRESS reminder, updates the reminderCount until the due date");
        System.err.println("    is greater than that specified. This updates the Next Reminder date accordingly");
        System.err.println();
        System.err.println("  --help");
        System.err.println("    Displays this help");
        System.err.println();
        System.err.println("Use: ");
        System.err.println("  --location to limit reminders those customers that have the specified ");
        System.err.println("             Practice Location with the specified location identifier.");
        System.err.println("  --dry-run  to show what will happen without making changes.");
        System.err.println("  --commit   to commit changes.");
        System.err.println();
        System.err.println("If both --remove-unsent-items and --update-reminder-counts are specified,");
        System.err.println("--remove-unsent-items is applied first");
        System.exit(1);
    }

    private static String asString(Entity entity) {
        return entity != null ? entity.getName() + " (" + entity.getId() + ")" : null;
    }

    private static class RemoveStatus {
        final int pending;
        final int errors;
        final boolean updated;

        RemoveStatus(int pending, int errors, boolean updated) {
            this.pending = pending;
            this.errors = errors;
            this.updated = updated;
        }
    }

    private static class Status {
        private final int updated;
        private final int skipped;
        private final int errors;

        Status() {
            this(0, 0, 0);
        }

        private Status(int updated, int skipped, int errors) {
            this.skipped = skipped;
            this.updated = updated;
            this.errors = errors;
        }

        Status add(Status other) {
            return new Status(this.updated + other.updated, this.skipped + other.skipped, this.errors + other.errors);
        }

        static Status noop() {
            return new Status();
        }

        static Status skip() {
            return new Status(0, 1, 0);
        }

        static Status error() {
            return new Status(0, 0, 1);
        }

        static Status update() {
            return new Status(1, 0, 0);
        }
    }
}

