/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.workflow.AbstractCalendarService;
import org.openvpms.archetype.rules.workflow.AppointmentFactory;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.archetype.rules.workflow.ScheduleTimes;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.RelationalOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppointmentService
extends AbstractCalendarService {
    private final IArchetypeServiceListener listener = new AbstractArchetypeServiceListener(){

        public void saved(IMObject object) {
            AppointmentService.this.onReasonSaved((Lookup)object);
        }

        public void removed(IMObject object) {
            AppointmentService.this.onReasonRemoved((Lookup)object);
        }
    };
    private static final String[] SHORT_NAMES = new String[]{"act.customerAppointment", "act.calendarBlock"};
    private static final Logger log = LoggerFactory.getLogger(AppointmentService.class);

    public AppointmentService(IArchetypeService service, LookupService lookupService, EhcacheManager cacheManager) {
        super(SHORT_NAMES, service, cacheManager, "appointmentCache", new AppointmentFactory(service, lookupService));
        service.addListener(ScheduleArchetypes.VISIT_REASON, this.listener);
    }

    public List<ScheduleTimes> getAppointmentsForClinician(User clinician, Date from, Date to) {
        return this.getAppointmentsForClinician(clinician, from, to, null);
    }

    public List<ScheduleTimes> getAppointmentsForClinician(User clinician, Date from, Date to, Act excluding) {
        ArrayList<ScheduleTimes> result = new ArrayList<ScheduleTimes>();
        ArchetypeQuery query = new ArchetypeQuery("act.customerAppointment", false, false);
        query.getArchetypeConstraint().setAlias("act");
        query.add((IConstraint)new ObjectRefSelectConstraint("act"));
        query.add((IConstraint)new ObjectRefSelectConstraint("schedule.entity"));
        query.add((IConstraint)new NodeSelectConstraint("startTime"));
        query.add((IConstraint)new NodeSelectConstraint("endTime"));
        JoinConstraint clinicianParticipation = this.createAppointmentJoin("clinician", from, to);
        clinicianParticipation.add((IConstraint)Constraints.eq((String)"entity", (Object)clinician));
        query.add((IConstraint)clinicianParticipation);
        JoinConstraint scheduleParticipation = this.createAppointmentJoin("schedule", from, to);
        scheduleParticipation.setAlias("schedule");
        query.add((IConstraint)scheduleParticipation);
        query.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.lt((String)"startTime", (Object)to), Constraints.gt((String)"endTime", (Object)from)}));
        query.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.ne((String)"status", (Object)"CANCELLED"), Constraints.ne((String)"status", (Object)"NO_SHOW")}));
        if (excluding != null) {
            query.add((IConstraint)Constraints.ne((String)"id", (Object)excluding.getId()));
        }
        IArchetypeService service = this.getService();
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            result.add(this.createScheduleTimes((ObjectSet)iterator.next()));
        }
        return result;
    }

    @Override
    public void destroy() throws Exception {
        try {
            this.getService().removeListener(ScheduleArchetypes.VISIT_REASON, this.listener);
        }
        finally {
            super.destroy();
        }
    }

    @Override
    protected AppointmentFactory getEventFactory() {
        return (AppointmentFactory)super.getEventFactory();
    }

    private JoinConstraint createAppointmentJoin(String node, Date from, Date to) {
        JoinConstraint participation = Constraints.join((String)node);
        participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.customerAppointment"));
        participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.LT, (Object)to));
        participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.GT, (Object)from));
        return participation;
    }

    private ScheduleTimes createScheduleTimes(ObjectSet set) {
        return new ScheduleTimes((Reference)set.getReference("act.reference"), (Reference)set.getReference("schedule.entity.reference"), set.getDate("act.startTime"), set.getDate("act.endTime"));
    }

    private void onReasonSaved(Lookup reason) {
        boolean updated = this.getEventFactory().addReason(reason);
        if (updated) {
            log.info("Appointment reason={} updated, clearing cache", (Object)reason.getCode());
            this.clearCache();
        }
    }

    private void onReasonRemoved(Lookup reason) {
        if (this.getEventFactory().removeReason(reason)) {
            log.info("Appointment reason={} removed, clearing cache", (Object)reason.getCode());
            this.clearCache();
        }
    }
}

