/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import java.util.Map;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleEventQuery;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.ObjectSet;

class AppointmentQuery
extends ScheduleEventQuery {
    private final Date lowerbound;
    private final Date upperbound;

    public AppointmentQuery(Entity schedule, Date from, Date to, Map<String, String> statusNames, Map<String, String> reasonNames, IArchetypeService service) {
        super(schedule, from, to, statusNames, reasonNames, service);
        IMObjectBean bean = service.getBean((IMObject)schedule);
        int maxDuration = bean.getInt("maxDuration", -1);
        DateUnits units = DateUnits.fromString(bean.getString("maxDurationUnits"), null);
        if (maxDuration > 0 && units != null) {
            this.lowerbound = DateRules.getDate(from, -maxDuration, units);
            this.upperbound = DateRules.getDate(to, maxDuration, units);
        } else {
            this.lowerbound = null;
            this.upperbound = null;
        }
    }

    @Override
    protected String getQueryName() {
        return this.lowerbound != null ? "getAppointmentEventsBounded" : "getAppointmentEvents";
    }

    @Override
    protected IArchetypeQuery createQuery(Entity schedule, Date from, Date to) {
        NamedQuery query = new NamedQuery(this.getQueryName(), NAMES);
        query.setParameter("scheduleId", (Object)schedule.getId());
        query.setParameter("from", (Object)from);
        query.setParameter("to", (Object)to);
        if (this.lowerbound != null) {
            query.setParameter("lowerbound", (Object)this.lowerbound);
            query.setParameter("upperbound", (Object)this.upperbound);
        }
        query.setMaxResults(-1);
        return query;
    }

    @Override
    protected String getScheduleType(String eventArchetype) {
        return "act.customerAppointment".equals(eventArchetype) ? "entity.appointmentType" : "entity.calendarBlockType";
    }

    @Override
    protected ObjectSet createEvent(Reference actRef, ObjectSet set) {
        ObjectSet event = super.createEvent(actRef, set);
        if (actRef.isA("act.customerAppointment")) {
            event.set("confirmedTime", null);
            event.set("arrivalTime", null);
            event.set("sendReminder", null);
            event.set("reminderSent", null);
            event.set("reminderError", null);
            event.set("smsStatus", null);
        }
        return event;
    }
}

