/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openvpms.archetype.rules.workflow.AppointmentQuery;
import org.openvpms.archetype.rules.workflow.ScheduleEventFactory;
import org.openvpms.archetype.rules.workflow.ScheduleEventQuery;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertySet;

class AppointmentFactory
extends ScheduleEventFactory {
    private final Map<String, String> reasonNames = Collections.synchronizedMap(new HashMap());

    public AppointmentFactory(IArchetypeService service, LookupService lookups) {
        super("act.customerAppointment", service, lookups);
        Map map = LookupHelper.getNames((IArchetypeService)service, (LookupService)lookups, (String)"act.customerAppointment", (String)"reason");
        this.reasonNames.putAll(map);
    }

    public boolean addReason(Lookup reason) {
        return this.reasonNames.put(reason.getCode(), reason.getName()) != null;
    }

    public boolean removeReason(Lookup reason) {
        return this.reasonNames.remove(reason.getCode()) != null;
    }

    @Override
    protected void assemble(PropertySet target, IMObjectBean source) {
        super.assemble(target, source);
        this.populate(target, source, "schedule");
        Act object = (Act)source.getObject(Act.class);
        if (source.isA(new String[]{"act.customerAppointment"})) {
            String reason = object.getReason();
            target.set("act.reason", (Object)reason);
            target.set("act.reasonName", (Object)this.reasonNames.get(reason));
            Reference typeRef = source.getTargetRef("appointmentType");
            String typeName = this.getName(typeRef);
            target.set("scheduleType.objectReference", (Object)typeRef);
            target.set("scheduleType.name", (Object)typeName);
            target.set("sendReminder", (Object)source.getBoolean("sendReminder"));
            target.set("reminderSent", (Object)source.getDate("reminderSent"));
            target.set("smsStatus", (Object)source.getString("smsStatus"));
            target.set("reminderError", (Object)source.getString("reminderError"));
            target.set("confirmedTime", (Object)source.getDate("confirmedTime"));
            target.set("arrivalTime", (Object)source.getDate("arrivalTime"));
            target.set("onlineBooking", (Object)source.getBoolean("onlineBooking"));
            target.set("bookingNotes", (Object)source.getString("bookingNotes"));
        } else {
            target.set("act.name", (Object)object.getName());
            Participation type = (Participation)source.getObject("type", Participation.class);
            this.populate(target, type, "scheduleType");
        }
    }

    @Override
    protected ScheduleEventQuery createQuery(Entity entity, Date startTime, Date endTime) {
        return new AppointmentQuery(entity, startTime, endTime, this.getStatusNames(), this.reasonNames, this.getService());
    }
}

